/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.kubernetes.config.CustomKubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CustomKubernetesHandlerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;

public class KubernetesResourceProperties {
    @Nonnull
    private final KubernetesHandler handler;
    private final boolean versioned;

    public KubernetesResourceProperties(@Nonnull KubernetesHandler handler, boolean versioned) {
        this.handler = Objects.requireNonNull(handler);
        this.versioned = versioned;
    }

    public static KubernetesResourceProperties fromCustomResource(CustomKubernetesResource customResource) {
        int deployPriorityValue;
        String deployPriority = customResource.getDeployPriority();
        if (Strings.isNullOrEmpty((String)deployPriority)) {
            deployPriorityValue = KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
        } else {
            try {
                deployPriorityValue = Integer.parseInt(deployPriority);
            }
            catch (NumberFormatException e) {
                deployPriorityValue = KubernetesHandler.DeployPriority.fromString(deployPriority).getValue();
            }
        }
        KubernetesHandler handler = CustomKubernetesHandlerFactory.create(KubernetesKind.fromString(customResource.getKubernetesKind()), SpinnakerKind.fromString(customResource.getSpinnakerKind()), customResource.isVersioned(), deployPriorityValue);
        return new KubernetesResourceProperties(handler, customResource.isVersioned());
    }

    @Nonnull
    @Generated
    public KubernetesHandler getHandler() {
        return this.handler;
    }

    @Generated
    public boolean isVersioned() {
        return this.versioned;
    }
}

