/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.CustomKubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesConfigurationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import javax.annotation.Nonnull;

public class CustomKubernetesHandlerFactory {
    public static KubernetesHandler create(KubernetesKind kubernetesKind, SpinnakerKind spinnakerKind, boolean versioned, int deployPriority) {
        return new Handler(kubernetesKind, spinnakerKind, versioned, deployPriority);
    }

    private static class Handler
    extends KubernetesHandler {
        private final KubernetesKind kubernetesKind;
        private final SpinnakerKind spinnakerKind;
        private final boolean versioned;
        private final int deployPriority;

        Handler(KubernetesKind kubernetesKind, SpinnakerKind spinnakerKind, boolean versioned, int deployPriority) {
            this.kubernetesKind = kubernetesKind;
            this.spinnakerKind = spinnakerKind;
            this.versioned = versioned;
            this.deployPriority = deployPriority;
        }

        @Override
        public int deployPriority() {
            return this.deployPriority;
        }

        @Override
        @Nonnull
        public KubernetesKind kind() {
            return this.kubernetesKind;
        }

        @Override
        public boolean versioned() {
            return this.versioned;
        }

        @Override
        @Nonnull
        public SpinnakerKind spinnakerKind() {
            return this.spinnakerKind;
        }

        @Override
        public Manifest.Status status(KubernetesManifest manifest) {
            return Manifest.Status.defaultStatus();
        }

        @Override
        protected KubernetesCachingAgentFactory cachingAgentFactory() {
            return this::buildCustomCachingAgent;
        }

        private KubernetesCachingAgent buildCustomCachingAgent(KubernetesNamedAccountCredentials namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval, KubernetesConfigurationProperties configurationProperties, KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap) {
            return CustomKubernetesCachingAgentFactory.create(this.kubernetesKind, namedAccountCredentials, objectMapper, registry, agentIndex, agentCount, agentInterval, configurationProperties, kubernetesSpinnakerKindMap);
        }
    }
}

