/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupHandler;
import io.kubernetes.client.openapi.models.V2alpha1CronJob;
import io.kubernetes.client.openapi.models.V2alpha1CronJobStatus;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class KubernetesCronJobHandler
extends KubernetesHandler
implements CanDelete,
ServerGroupHandler {
    @Override
    @Nonnull
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.cronJobDockerImage(), (Object)Replacer.configMapVolume(), (Object)Replacer.secretVolume(), (Object)Replacer.configMapProjectedVolume(), (Object)Replacer.secretProjectedVolume(), (Object)Replacer.configMapEnv(), (Object)Replacer.secretEnv(), (Object)Replacer.configMapKeyValue(), (Object)Replacer.secretKeyValue());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.CRON_JOB;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V2alpha1CronJob v2alpha1CronJob = KubernetesCacheDataConverter.getResource(manifest, V2alpha1CronJob.class);
        return this.status(v2alpha1CronJob);
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    private Manifest.Status status(V2alpha1CronJob job) {
        V2alpha1CronJobStatus status = job.getStatus();
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        return Manifest.Status.defaultStatus();
    }
}

