/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanRollingRestart;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupManagerHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnstableReason;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnsupportedVersionException;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentCondition;
import io.kubernetes.client.openapi.models.V1DeploymentStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
public class KubernetesDeploymentHandler
extends KubernetesHandler
implements CanResize,
CanScale,
CanPauseRollout,
CanResumeRollout,
CanUndoRollout,
CanRollingRestart,
ServerGroupManagerHandler {
    private static final ImmutableSet<KubernetesApiVersion> SUPPORTED_API_VERSIONS = ImmutableSet.of((Object)KubernetesApiVersion.APPS_V1);

    @Override
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.dockerImage(), (Object)Replacer.configMapVolume(), (Object)Replacer.secretVolume(), (Object)Replacer.configMapProjectedVolume(), (Object)Replacer.secretProjectedVolume(), (Object)Replacer.configMapEnv(), (Object)Replacer.secretEnv(), (Object)Replacer.configMapKeyValue(), (Object)Replacer.secretKeyValue());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.DEPLOYMENT;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.SERVER_GROUP_MANAGERS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        if (!SUPPORTED_API_VERSIONS.contains((Object)manifest.getApiVersion())) {
            throw new UnsupportedVersionException(manifest);
        }
        V1Deployment appsV1Deployment = KubernetesCacheDataConverter.getResource(manifest, V1Deployment.class);
        return this.status(appsV1Deployment);
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    private Manifest.Status status(V1Deployment deployment) {
        V1DeploymentStatus status = deployment.getStatus();
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        if (!this.generationMatches(deployment, status)) {
            return Manifest.Status.defaultStatus().unstable(UnstableReason.OLD_GENERATION.getMessage());
        }
        List conditions = Optional.ofNullable(status.getConditions()).orElse((List)ImmutableList.of());
        Manifest.Status result = Manifest.Status.defaultStatus();
        KubernetesDeploymentHandler.getPausedReason(conditions).ifPresent(result::paused);
        KubernetesDeploymentHandler.getUnavailableReason(conditions).ifPresent(reason -> result.unstable((String)reason).unavailable((String)reason));
        KubernetesDeploymentHandler.getFailedReason(conditions).ifPresent(result::failed);
        KubernetesDeploymentHandler.checkReplicaCounts(deployment, status).ifPresent(reason -> result.unstable(reason.getMessage()));
        return result;
    }

    private static Optional<String> getUnavailableReason(Collection<V1DeploymentCondition> conditions) {
        return conditions.stream().filter(c -> c.getType().equalsIgnoreCase("available")).filter(c -> c.getStatus().equalsIgnoreCase("false")).map(V1DeploymentCondition::getMessage).findAny();
    }

    private static Optional<String> getPausedReason(Collection<V1DeploymentCondition> conditions) {
        return conditions.stream().filter(c -> c.getReason() != null).filter(c -> c.getReason().equalsIgnoreCase("deploymentpaused")).map(V1DeploymentCondition::getMessage).findAny();
    }

    private static Optional<String> getFailedReason(Collection<V1DeploymentCondition> conditions) {
        return conditions.stream().filter(c -> c.getType().equalsIgnoreCase("progressing")).filter(c -> c.getReason() != null).filter(c -> c.getReason().equalsIgnoreCase("progressdeadlineexceeded")).map(c -> "Deployment exceeded its progress deadline").findAny();
    }

    private boolean generationMatches(V1Deployment deployment, V1DeploymentStatus status) {
        Optional<Long> metadataGeneration = Optional.ofNullable(deployment.getMetadata()).map(V1ObjectMeta::getGeneration);
        Optional<Long> statusGeneration = Optional.ofNullable(status.getObservedGeneration());
        return statusGeneration.isPresent() && statusGeneration.equals(metadataGeneration);
    }

    private static int defaultToZero(@Nullable Integer input) {
        return input == null ? 0 : input;
    }

    private static Optional<UnstableReason> checkReplicaCounts(V1Deployment deployment, V1DeploymentStatus status) {
        int desiredReplicas = KubernetesDeploymentHandler.defaultToZero(deployment.getSpec().getReplicas());
        int updatedReplicas = KubernetesDeploymentHandler.defaultToZero(status.getUpdatedReplicas());
        if (updatedReplicas < desiredReplicas) {
            return Optional.of(UnstableReason.UPDATED_REPLICAS);
        }
        int statusReplicas = KubernetesDeploymentHandler.defaultToZero(status.getReplicas());
        if (statusReplicas > updatedReplicas) {
            return Optional.of(UnstableReason.OLD_REPLICAS);
        }
        int availableReplicas = KubernetesDeploymentHandler.defaultToZero(status.getAvailableReplicas());
        if (availableReplicas < desiredReplicas) {
            return Optional.of(UnstableReason.AVAILABLE_REPLICAS);
        }
        int readyReplicas = KubernetesDeploymentHandler.defaultToZero(status.getReadyReplicas());
        if (readyReplicas < desiredReplicas) {
            return Optional.of(UnstableReason.READY_REPLICAS);
        }
        return Optional.empty();
    }
}

