/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupHandler;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.kubernetes.client.openapi.models.V1JobSpec;
import io.kubernetes.client.openapi.models.V1JobStatus;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class KubernetesJobHandler
extends KubernetesHandler
implements ServerGroupHandler {
    @Override
    @Nonnull
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.dockerImage(), (Object)Replacer.configMapVolume(), (Object)Replacer.secretVolume(), (Object)Replacer.configMapProjectedVolume(), (Object)Replacer.secretProjectedVolume(), (Object)Replacer.configMapEnv(), (Object)Replacer.secretEnv(), (Object)Replacer.configMapKeyValue(), (Object)Replacer.secretKeyValue());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.JOB;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V1Job v1Job = KubernetesCacheDataConverter.getResource(manifest, V1Job.class);
        return this.status(v1Job);
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    private Manifest.Status status(V1Job job) {
        V1JobStatus status = job.getStatus();
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        int completions = 1;
        V1JobSpec spec = job.getSpec();
        if (spec != null && spec.getCompletions() != null) {
            completions = spec.getCompletions();
        }
        int succeeded = 0;
        if (status.getSucceeded() != null) {
            succeeded = status.getSucceeded();
        }
        if (succeeded < completions) {
            List conditions = status.getConditions();
            conditions = conditions != null ? conditions : ImmutableList.of();
            Optional<V1JobCondition> condition = conditions.stream().filter(this::jobFailed).findAny();
            return condition.map(v1JobCondition -> Manifest.Status.defaultStatus().failed(v1JobCondition.getMessage())).orElseGet(() -> Manifest.Status.defaultStatus().unstable("Waiting for jobs to finish"));
        }
        return Manifest.Status.defaultStatus();
    }

    private boolean jobFailed(V1JobCondition condition) {
        return "Failed".equalsIgnoreCase(condition.getType()) && "True".equalsIgnoreCase(condition.getStatus());
    }
}

