/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.job;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Streams;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPodMetric;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
final class MetricParser {
    private static final Splitter lineSplitter = Splitter.on((char)'\n').trimResults().omitEmptyStrings();

    MetricParser() {
    }

    static ImmutableSetMultimap<String, KubernetesPodMetric.ContainerMetric> parseMetrics(String kubectlOutput) {
        Iterator lines = lineSplitter.split((CharSequence)kubectlOutput.trim()).iterator();
        if (!lines.hasNext()) {
            return ImmutableSetMultimap.of();
        }
        Optional<LineParser> optionalParser = LineParser.withHeader((String)lines.next());
        if (!optionalParser.isPresent()) {
            return ImmutableSetMultimap.of();
        }
        LineParser parser = optionalParser.get();
        return (ImmutableSetMultimap)Streams.stream(lines).map(x$0 -> parser.readLine((String)x$0)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSetMultimap.toImmutableSetMultimap(MetricLine::getPod, MetricLine::toContainerMetric));
    }

    private static final class MetricLine {
        private final String pod;
        private final String container;
        private final ImmutableMap<String, String> metrics;

        private MetricLine(String pod, String container, Map<String, String> metrics) {
            this.pod = pod;
            this.container = container;
            this.metrics = ImmutableMap.copyOf(metrics);
        }

        KubernetesPodMetric.ContainerMetric toContainerMetric() {
            return new KubernetesPodMetric.ContainerMetric(this.container, (Map<String, String>)this.metrics);
        }

        @Generated
        public String getPod() {
            return this.pod;
        }
    }

    private static final class LineParser {
        private static final Logger log = LoggerFactory.getLogger(LineParser.class);
        private static final Splitter columnSplitter = Splitter.on((Pattern)Pattern.compile("\\s+")).trimResults();
        private final ImmutableList<String> headers;

        private LineParser(Iterable<String> header) throws IllegalArgumentException {
            ImmutableList headers = ImmutableList.copyOf(header);
            if (headers.size() <= 2) {
                throw new IllegalArgumentException(String.format("Unexpected metric format -- no metrics to report based on table header %s.", headers));
            }
            this.headers = headers;
        }

        static Optional<LineParser> withHeader(String header) {
            try {
                return Optional.of(new LineParser(columnSplitter.split((CharSequence)header)));
            }
            catch (IllegalArgumentException e) {
                log.warn(e.getMessage());
                return Optional.empty();
            }
        }

        private Optional<MetricLine> readLine(String line) {
            List entry = columnSplitter.splitToList((CharSequence)line);
            if (entry.size() != this.headers.size()) {
                log.warn("Entry {} does not match column width of {}, skipping", (Object)entry, this.headers);
                return Optional.empty();
            }
            String podName = (String)entry.get(0);
            String containerName = (String)entry.get(1);
            ImmutableMap.Builder metrics = ImmutableMap.builder();
            for (int j = 2; j < this.headers.size(); ++j) {
                metrics.put((Object)((String)this.headers.get(j)), (Object)((String)entry.get(j)));
            }
            return Optional.of(new MetricLine(podName, containerName, (Map<String, String>)metrics.build()));
        }
    }
}

