/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesUndoRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesUndoRolloutManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesUndoRolloutManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "UNDO_ROLLOUT_KUBERNETES_MANIFEST";

    public KubernetesUndoRolloutManifestOperation(KubernetesUndoRolloutManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Starting undo rollout operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(coordinates.getKind()).getHandler();
        if (!(deployer instanceof CanUndoRollout)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support undo rollout");
        }
        CanUndoRollout canUndoRollout = (CanUndoRollout)((Object)deployer);
        Integer revision = this.description.getRevision();
        if (this.description.getNumRevisionsBack() != null) {
            KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up rollout history...");
            List<Integer> revisions = canUndoRollout.historyRollout(this.credentials, coordinates.getNamespace(), coordinates.getName());
            revisions.sort(Integer::compareTo);
            int numRevisions = revisions.size();
            int targetRevisionIndex = numRevisions - this.description.getNumRevisionsBack() - 1;
            if (targetRevisionIndex < 0) {
                throw new IllegalArgumentException("There are " + numRevisions + " revision(s) in total, cannot rollback " + this.description.getNumRevisionsBack());
            }
            revision = revisions.get(targetRevisionIndex);
            KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Picked revision " + revision + "...");
        }
        KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Calling undo rollout operation...");
        canUndoRollout.undoRollout(this.credentials, coordinates.getNamespace(), coordinates.getName(), revision);
        return null;
    }
}

