/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.provider.view;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyParser {
    private static final Logger log = LoggerFactory.getLogger(PropertyParser.class);
    private static final String MAGIC_SEARCH_STRING = "SPINNAKER_PROPERTY_";
    private static final Pattern MAGIC_SEARCH_PATTERN = Pattern.compile("SPINNAKER_PROPERTY_");
    private static final String MAGIC_JSON_SEARCH_STRING = "SPINNAKER_CONFIG_JSON=";
    private static final Pattern MAGIC_JSON_SEARCH_PATTERN = Pattern.compile("^\\s*SPINNAKER_CONFIG_JSON=");
    private static final Splitter lineSplitter = Splitter.on((String)"\n").omitEmptyStrings().trimResults();
    private static final Splitter equalsSplitter = Splitter.on((String)"=").omitEmptyStrings().trimResults();

    public static Map<String, Object> extractPropertiesFromLog(String buildLog) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String line : lineSplitter.split((CharSequence)buildLog)) {
            if (MAGIC_SEARCH_PATTERN.matcher(line).find()) {
                log.debug("Identified: " + line);
                List splittedLine = equalsSplitter.splitToList((CharSequence)line);
                if (splittedLine.size() != 2) continue;
                String key = ((String)splittedLine.get(0)).replaceFirst(MAGIC_SEARCH_STRING, "").toLowerCase();
                String value = (String)splittedLine.get(1);
                log.debug(key + ":" + value);
                map.put(key, value);
            }
            if (!MAGIC_JSON_SEARCH_PATTERN.matcher(line).find()) continue;
            log.debug("Identified Spinnaker JSON properties magic string: " + line);
            String jsonContent = line.replaceFirst(MAGIC_JSON_SEARCH_STRING, "");
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                map.putAll((Map)objectMapper.readValue(jsonContent, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
            catch (IOException e) {
                log.error("Unable to parse content from {}. Content is: {}", (Object)MAGIC_JSON_SEARCH_STRING, (Object)jsonContent);
                throw e;
            }
        }
        return map;
    }
}

