/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.config.CustomKubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesAccountProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesCachingPolicy;
import com.netflix.spinnaker.clouddriver.kubernetes.config.LinkedDockerRegistryConfiguration;
import com.netflix.spinnaker.clouddriver.kubernetes.config.RawResourcesEndpointConfig;
import com.netflix.spinnaker.clouddriver.kubernetes.description.AccountResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.GlobalResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPodMetric;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.ResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKindProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.names.KubernetesNamerRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesCustomResourceHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubeconfigFileHasher;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesKindRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesSelectorList;
import com.netflix.spinnaker.clouddriver.names.NamingStrategy;
import com.netflix.spinnaker.kork.configserver.ConfigFileService;
import com.netflix.spinnaker.moniker.Namer;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1beta1CustomResourceDefinition;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

public class KubernetesCredentials {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCredentials.class);
    private static final int CRD_EXPIRY_SECONDS = 30;
    private static final int NAMESPACE_EXPIRY_SECONDS = 30;
    private final Registry registry;
    private final Clock clock;
    private final KubectlJobExecutor jobExecutor;
    private final GlobalResourcePropertyRegistry globalResourcePropertyRegistry;
    @Nonnull
    private final String accountName;
    private final ImmutableList<String> namespaces;
    private final ImmutableList<String> omitNamespaces;
    private final ImmutableSet<KubernetesKind> kinds;
    private final ImmutableSet<KubernetesKind> omitKinds;
    private final List<CustomKubernetesResource> customResources;
    private final String kubectlExecutable;
    private final Integer kubectlRequestTimeoutSeconds;
    private final String kubeconfigFile;
    private final String kubeconfigFileHash;
    private final boolean serviceAccount;
    private final String context;
    private final boolean onlySpinnakerManaged;
    private final boolean cacheAllApplicationRelationships;
    private final RawResourcesEndpointConfig rawResourcesEndpointConfig;
    private final boolean checkPermissionsOnStartup;
    private final List<KubernetesCachingPolicy> cachingPolicies;
    @JsonIgnore
    private final String oAuthServiceAccount;
    @JsonIgnore
    private final List<String> oAuthScopes;
    private boolean metrics;
    private final boolean debug;
    private final ResourcePropertyRegistry resourcePropertyRegistry;
    private final KubernetesKindRegistry kindRegistry;
    private final KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap;
    private final PermissionValidator permissionValidator;
    private final Supplier<ImmutableMap<KubernetesKind, KubernetesKindProperties>> crdSupplier = Suppliers.memoizeWithExpiration(this::crdSupplier, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    private final Memoizer<ImmutableList<String>> liveNamespaceSupplier = Memoizer.memoizeWithExpiration(this::namespaceSupplier, 30L, TimeUnit.SECONDS);
    private final Namer<KubernetesManifest> namer;

    public KubernetesCredentials(Registry registry, KubectlJobExecutor jobExecutor, KubernetesAccountProperties.ManagedAccount managedAccount, AccountResourcePropertyRegistry.Factory resourcePropertyRegistryFactory, KubernetesKindRegistry.Factory kindRegistryFactory, KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap, String kubeconfigFile, Namer<KubernetesManifest> manifestNamer, GlobalResourcePropertyRegistry globalResourcePropertyRegistry) {
        this.registry = registry;
        this.clock = registry.clock();
        this.jobExecutor = jobExecutor;
        this.kindRegistry = kindRegistryFactory.create(this::getCrdProperties, (Iterable)managedAccount.getCustomResources().stream().map(cr -> KubernetesKindProperties.create(KubernetesKind.fromString(cr.getKubernetesKind()), cr.isNamespaced())).collect(ImmutableList.toImmutableList()));
        this.accountName = Objects.requireNonNull(managedAccount.getName());
        this.namespaces = ImmutableList.copyOf(managedAccount.getNamespaces());
        this.omitNamespaces = ImmutableList.copyOf(managedAccount.getOmitNamespaces());
        this.kinds = (ImmutableSet)managedAccount.getKinds().stream().map(KubernetesKind::fromString).collect(ImmutableSet.toImmutableSet());
        this.omitKinds = (ImmutableSet)managedAccount.getOmitKinds().stream().map(KubernetesKind::fromString).collect(ImmutableSet.toImmutableSet());
        this.permissionValidator = new PermissionValidator();
        this.customResources = managedAccount.getCustomResources();
        this.resourcePropertyRegistry = resourcePropertyRegistryFactory.create((Collection)managedAccount.getCustomResources().stream().map(KubernetesResourceProperties::fromCustomResource).collect(ImmutableList.toImmutableList()));
        this.kubernetesSpinnakerKindMap = kubernetesSpinnakerKindMap;
        this.kubectlExecutable = managedAccount.getKubectlExecutable();
        this.kubectlRequestTimeoutSeconds = managedAccount.getKubectlRequestTimeoutSeconds();
        this.kubeconfigFile = kubeconfigFile;
        this.kubeconfigFileHash = KubeconfigFileHasher.hashKubeconfigFile(kubeconfigFile);
        this.serviceAccount = managedAccount.isServiceAccount();
        this.context = managedAccount.getContext();
        this.onlySpinnakerManaged = managedAccount.isOnlySpinnakerManaged();
        this.checkPermissionsOnStartup = managedAccount.isCheckPermissionsOnStartup();
        this.cachingPolicies = managedAccount.getCachingPolicies();
        this.oAuthServiceAccount = managedAccount.getOAuthServiceAccount();
        this.oAuthScopes = managedAccount.getOAuthScopes();
        this.metrics = managedAccount.isMetrics();
        this.debug = managedAccount.isDebug();
        this.namer = manifestNamer;
        this.cacheAllApplicationRelationships = managedAccount.isCacheAllApplicationRelationships();
        this.rawResourcesEndpointConfig = managedAccount.getRawResourcesEndpointConfig();
        this.globalResourcePropertyRegistry = globalResourcePropertyRegistry;
    }

    public boolean isValidKind(@Nonnull KubernetesKind kind) {
        return this.getKindStatus(kind) == KubernetesKindStatus.VALID;
    }

    @Nonnull
    public KubernetesKindStatus getKindStatus(@Nonnull KubernetesKind kind) {
        if (kind.equals(KubernetesKind.NONE)) {
            return KubernetesKindStatus.KIND_NONE;
        }
        if (!this.kinds.isEmpty()) {
            return this.kinds.contains((Object)kind) ? KubernetesKindStatus.VALID : KubernetesKindStatus.MISSING_FROM_ALLOWED_KINDS;
        }
        if (this.omitKinds.contains((Object)kind)) {
            return KubernetesKindStatus.EXPLICITLY_OMITTED_BY_CONFIGURATION;
        }
        if (!this.kindRegistry.isKindRegistered(kind)) {
            return KubernetesKindStatus.UNKNOWN;
        }
        if (!this.permissionValidator.isKindReadable(kind)) {
            return KubernetesKindStatus.READ_ERROR;
        }
        return KubernetesKindStatus.VALID;
    }

    private Optional<KubernetesKindProperties> getCrdProperties(@Nonnull KubernetesKind kubernetesKind) {
        return Optional.ofNullable((KubernetesKindProperties)this.crdSupplier.get().get((Object)kubernetesKind));
    }

    @Nonnull
    public ImmutableList<KubernetesKind> getGlobalKinds() {
        return (ImmutableList)this.kindRegistry.getGlobalKinds().stream().filter(this::isValidKind).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public KubernetesKindProperties getKindProperties(@Nonnull KubernetesKind kind) {
        return this.kindRegistry.getKindPropertiesOrDefault(kind);
    }

    @Nonnull
    public ImmutableList<KubernetesKind> getCrds() {
        return (ImmutableList)this.crdSupplier.get().keySet().stream().filter(this::isValidKind).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableMap<KubernetesKind, KubernetesKindProperties> crdSupplier() {
        if (!this.isValidKind(KubernetesKind.CUSTOM_RESOURCE_DEFINITION)) {
            return ImmutableMap.of();
        }
        try {
            ImmutableMap crds = (ImmutableMap)this.list(KubernetesKind.CUSTOM_RESOURCE_DEFINITION, "").stream().map(manifest -> KubernetesCacheDataConverter.getResource(manifest, V1beta1CustomResourceDefinition.class)).map(KubernetesKindProperties::fromCustomResourceDefinition).collect(ImmutableMap.toImmutableMap(KubernetesKindProperties::getKubernetesKind, Function.identity()));
            List crdHandlers = (List)crds.keySet().stream().map(KubernetesCustomResourceHandler::new).collect(ImmutableList.toImmutableList());
            this.globalResourcePropertyRegistry.updateCrdProperties(crdHandlers);
            return crds;
        }
        catch (KubectlJobExecutor.KubectlException e) {
            return ImmutableMap.of();
        }
    }

    @Nonnull
    private ImmutableList<String> namespaceSupplier() {
        try {
            return (ImmutableList)this.jobExecutor.list(this, (List<KubernetesKind>)ImmutableList.of((Object)KubernetesKind.NAMESPACE), "", new KubernetesSelectorList()).stream().map(KubernetesManifest::getName).collect(ImmutableList.toImmutableList());
        }
        catch (KubectlJobExecutor.KubectlException e) {
            log.error("Could not list namespaces for account {}: {}", (Object)this.accountName, (Object)e.getMessage());
            return ImmutableList.of();
        }
    }

    @Nonnull
    public ImmutableList<String> filterNamespaces(@Nonnull ImmutableList<String> namespaces) {
        ImmutableList result = namespaces;
        if (!this.omitNamespaces.isEmpty()) {
            result = (ImmutableList)result.stream().filter(n -> !this.omitNamespaces.contains(n)).collect(ImmutableList.toImmutableList());
        }
        return result;
    }

    @Nonnull
    public ImmutableList<String> getDeclaredNamespacesFromCache() {
        ImmutableList<String> result;
        if (!this.namespaces.isEmpty()) {
            result = this.namespaces;
        } else {
            result = this.liveNamespaceSupplier.getIfPresent();
            if (result == null) {
                log.warn("No cached namespaces for account {}", (Object)this.accountName);
                result = ImmutableList.of();
            }
        }
        return this.filterNamespaces(result);
    }

    @Nonnull
    public ImmutableList<String> getDeclaredNamespaces() {
        ImmutableList<String> result = !this.namespaces.isEmpty() ? this.namespaces : this.liveNamespaceSupplier.get();
        return this.filterNamespaces(result);
    }

    public boolean isMetricsEnabled() {
        return this.metrics && this.permissionValidator.isMetricsReadable();
    }

    public Map<String, String> getSpinnakerKindMap() {
        HashMap<String, String> kindMap = new HashMap<String, String>(this.kubernetesSpinnakerKindMap.kubernetesToSpinnakerKindStringMap());
        this.getCustomResources().forEach(customResource -> kindMap.put(customResource.getKubernetesKind(), customResource.getSpinnakerKind()));
        return kindMap;
    }

    public ImmutableList<LinkedDockerRegistryConfiguration> getDockerRegistries() {
        return ImmutableList.of();
    }

    @Deprecated
    @Nullable
    public KubernetesManifest get(KubernetesKind kind, String namespace, String name) {
        return this.get(KubernetesCoordinates.builder().kind(kind).namespace(namespace).name(name).build());
    }

    @Nullable
    public KubernetesManifest get(KubernetesCoordinates coords) {
        return this.runAndRecordMetrics("get", coords.getKind(), coords.getNamespace(), () -> this.jobExecutor.get(this, coords.getKind(), coords.getNamespace(), coords.getName()));
    }

    @Nonnull
    public ImmutableList<KubernetesManifest> list(KubernetesKind kind, String namespace) {
        return this.runAndRecordMetrics("list", kind, namespace, () -> this.jobExecutor.list(this, (List<KubernetesKind>)ImmutableList.of((Object)kind), namespace, new KubernetesSelectorList()));
    }

    @Nonnull
    public ImmutableList<KubernetesManifest> list(KubernetesKind kind, String namespace, KubernetesSelectorList selectors) {
        return this.runAndRecordMetrics("list", kind, namespace, () -> this.jobExecutor.list(this, (List<KubernetesKind>)ImmutableList.of((Object)kind), namespace, selectors));
    }

    @Nonnull
    public ImmutableList<KubernetesManifest> list(List<KubernetesKind> kinds, String namespace) {
        if (kinds.isEmpty()) {
            return ImmutableList.of();
        }
        return this.runAndRecordMetrics("list", kinds, namespace, () -> this.jobExecutor.list(this, kinds, namespace, new KubernetesSelectorList()));
    }

    @Deprecated
    @Nonnull
    public ImmutableList<KubernetesManifest> eventsFor(KubernetesKind kind, String namespace, String name) {
        return this.eventsFor(KubernetesCoordinates.builder().kind(kind).namespace(namespace).name(name).build());
    }

    @Nonnull
    public ImmutableList<KubernetesManifest> eventsFor(KubernetesCoordinates coords) {
        return this.runAndRecordMetrics("list", KubernetesKind.EVENT, coords.getNamespace(), () -> this.jobExecutor.eventsFor(this, coords.getKind(), coords.getNamespace(), coords.getName()));
    }

    public String logs(String namespace, String podName, String containerName) {
        return this.runAndRecordMetrics("logs", KubernetesKind.POD, namespace, () -> this.jobExecutor.logs(this, namespace, podName, containerName));
    }

    public String jobLogs(String namespace, String jobName, String containerName) {
        return this.runAndRecordMetrics("logs", KubernetesKind.JOB, namespace, () -> this.jobExecutor.jobLogs(this, namespace, jobName, containerName));
    }

    public void scale(KubernetesKind kind, String namespace, String name, int replicas) {
        this.runAndRecordMetrics("scale", kind, namespace, () -> this.jobExecutor.scale(this, kind, namespace, name, replicas));
    }

    public List<String> delete(KubernetesKind kind, String namespace, String name, KubernetesSelectorList labelSelectors, V1DeleteOptions options) {
        return this.runAndRecordMetrics("delete", kind, namespace, () -> this.jobExecutor.delete(this, kind, namespace, name, labelSelectors, options));
    }

    @Deprecated
    public Collection<KubernetesPodMetric> topPod(String namespace, String pod) {
        return this.topPod(KubernetesCoordinates.builder().kind(KubernetesKind.POD).namespace(namespace).name(pod).build());
    }

    public Collection<KubernetesPodMetric> topPod(KubernetesCoordinates coords) {
        Preconditions.checkState((boolean)coords.getKind().equals(KubernetesKind.POD), (Object)"Metrics are only available for pods.");
        return (Collection)this.runAndRecordMetrics("top", KubernetesKind.POD, coords.getNamespace(), () -> this.jobExecutor.topPod(this, coords.getNamespace(), coords.getName()));
    }

    public KubernetesManifest deploy(KubernetesManifest manifest) {
        return this.runAndRecordMetrics("deploy", manifest.getKind(), manifest.getNamespace(), () -> this.jobExecutor.deploy(this, manifest));
    }

    private KubernetesManifest replace(KubernetesManifest manifest) {
        return this.runAndRecordMetrics("replace", manifest.getKind(), manifest.getNamespace(), () -> this.jobExecutor.replace(this, manifest));
    }

    public KubernetesManifest createOrReplace(KubernetesManifest manifest) {
        try {
            return this.replace(manifest);
        }
        catch (KubectlJobExecutor.KubectlNotFoundException e) {
            return this.create(manifest);
        }
    }

    public KubernetesManifest create(KubernetesManifest manifest) {
        return this.runAndRecordMetrics("create", manifest.getKind(), manifest.getNamespace(), () -> this.jobExecutor.create(this, manifest));
    }

    public List<Integer> historyRollout(KubernetesKind kind, String namespace, String name) {
        return this.runAndRecordMetrics("historyRollout", kind, namespace, () -> this.jobExecutor.historyRollout(this, kind, namespace, name));
    }

    public void undoRollout(KubernetesKind kind, String namespace, String name, int revision) {
        this.runAndRecordMetrics("undoRollout", kind, namespace, () -> this.jobExecutor.undoRollout(this, kind, namespace, name, revision));
    }

    public void pauseRollout(KubernetesKind kind, String namespace, String name) {
        this.runAndRecordMetrics("pauseRollout", kind, namespace, () -> this.jobExecutor.pauseRollout(this, kind, namespace, name));
    }

    public void resumeRollout(KubernetesKind kind, String namespace, String name) {
        this.runAndRecordMetrics("resumeRollout", kind, namespace, () -> this.jobExecutor.resumeRollout(this, kind, namespace, name));
    }

    public void rollingRestart(KubernetesKind kind, String namespace, String name) {
        this.runAndRecordMetrics("rollingRestart", kind, namespace, () -> this.jobExecutor.rollingRestart(this, kind, namespace, name));
    }

    public void patch(KubernetesKind kind, String namespace, String name, KubernetesPatchOptions options, KubernetesManifest manifest) {
        this.runAndRecordMetrics("patch", kind, namespace, () -> this.jobExecutor.patch(this, kind, namespace, name, options, manifest));
    }

    public void patch(KubernetesKind kind, String namespace, String name, KubernetesPatchOptions options, List<JsonPatch> patches) {
        this.runAndRecordMetrics("patch", kind, namespace, () -> this.jobExecutor.patch(this, kind, namespace, name, options, patches));
    }

    private <T> T runAndRecordMetrics(String action, KubernetesKind kind, String namespace, Supplier<T> op) {
        return this.runAndRecordMetrics(action, (List<KubernetesKind>)ImmutableList.of((Object)kind), namespace, op);
    }

    private <T> T runAndRecordMetrics(String action, List<KubernetesKind> kinds, String namespace, Supplier<T> op) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("action", action);
        tags.put("kinds", kinds.stream().map(KubernetesKind::toString).sorted().collect(Collectors.joining(",")));
        tags.put("account", this.accountName);
        tags.put("namespace", Strings.isNullOrEmpty((String)namespace) ? "none" : namespace);
        tags.put("success", "true");
        long startTime = this.clock.monotonicTime();
        try {
            T t = op.get();
            return t;
        }
        catch (RuntimeException e) {
            tags.put("success", "false");
            tags.put("reason", e.getClass().getSimpleName());
            throw e;
        }
        finally {
            this.registry.timer(this.registry.createId("kubernetes.api", tags)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesCredentials)) {
            return false;
        }
        KubernetesCredentials other = (KubernetesCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isServiceAccount() != other.isServiceAccount()) {
            return false;
        }
        if (this.isOnlySpinnakerManaged() != other.isOnlySpinnakerManaged()) {
            return false;
        }
        if (this.isCacheAllApplicationRelationships() != other.isCacheAllApplicationRelationships()) {
            return false;
        }
        if (this.checkPermissionsOnStartup != other.checkPermissionsOnStartup) {
            return false;
        }
        if (this.metrics != other.metrics) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        Integer this$kubectlRequestTimeoutSeconds = this.getKubectlRequestTimeoutSeconds();
        Integer other$kubectlRequestTimeoutSeconds = other.getKubectlRequestTimeoutSeconds();
        if (this$kubectlRequestTimeoutSeconds == null ? other$kubectlRequestTimeoutSeconds != null : !((Object)this$kubectlRequestTimeoutSeconds).equals(other$kubectlRequestTimeoutSeconds)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        ImmutableList<String> this$namespaces = this.getNamespaces();
        ImmutableList<String> other$namespaces = other.getNamespaces();
        if (this$namespaces == null ? other$namespaces != null : !this$namespaces.equals(other$namespaces)) {
            return false;
        }
        ImmutableList<String> this$omitNamespaces = this.getOmitNamespaces();
        ImmutableList<String> other$omitNamespaces = other.getOmitNamespaces();
        if (this$omitNamespaces == null ? other$omitNamespaces != null : !this$omitNamespaces.equals(other$omitNamespaces)) {
            return false;
        }
        ImmutableSet<KubernetesKind> this$kinds = this.getKinds();
        ImmutableSet<KubernetesKind> other$kinds = other.getKinds();
        if (this$kinds == null ? other$kinds != null : !this$kinds.equals(other$kinds)) {
            return false;
        }
        ImmutableSet<KubernetesKind> this$omitKinds = this.getOmitKinds();
        ImmutableSet<KubernetesKind> other$omitKinds = other.getOmitKinds();
        if (this$omitKinds == null ? other$omitKinds != null : !this$omitKinds.equals(other$omitKinds)) {
            return false;
        }
        List<CustomKubernetesResource> this$customResources = this.getCustomResources();
        List<CustomKubernetesResource> other$customResources = other.getCustomResources();
        if (this$customResources == null ? other$customResources != null : !((Object)this$customResources).equals(other$customResources)) {
            return false;
        }
        String this$kubectlExecutable = this.getKubectlExecutable();
        String other$kubectlExecutable = other.getKubectlExecutable();
        if (this$kubectlExecutable == null ? other$kubectlExecutable != null : !this$kubectlExecutable.equals(other$kubectlExecutable)) {
            return false;
        }
        String this$kubeconfigFileHash = this.kubeconfigFileHash;
        String other$kubeconfigFileHash = other.kubeconfigFileHash;
        if (this$kubeconfigFileHash == null ? other$kubeconfigFileHash != null : !this$kubeconfigFileHash.equals(other$kubeconfigFileHash)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        RawResourcesEndpointConfig this$rawResourcesEndpointConfig = this.getRawResourcesEndpointConfig();
        RawResourcesEndpointConfig other$rawResourcesEndpointConfig = other.getRawResourcesEndpointConfig();
        if (this$rawResourcesEndpointConfig == null ? other$rawResourcesEndpointConfig != null : !((Object)this$rawResourcesEndpointConfig).equals(other$rawResourcesEndpointConfig)) {
            return false;
        }
        List<KubernetesCachingPolicy> this$cachingPolicies = this.getCachingPolicies();
        List<KubernetesCachingPolicy> other$cachingPolicies = other.getCachingPolicies();
        if (this$cachingPolicies == null ? other$cachingPolicies != null : !((Object)this$cachingPolicies).equals(other$cachingPolicies)) {
            return false;
        }
        String this$oAuthServiceAccount = this.getOAuthServiceAccount();
        String other$oAuthServiceAccount = other.getOAuthServiceAccount();
        if (this$oAuthServiceAccount == null ? other$oAuthServiceAccount != null : !this$oAuthServiceAccount.equals(other$oAuthServiceAccount)) {
            return false;
        }
        List<String> this$oAuthScopes = this.getOAuthScopes();
        List<String> other$oAuthScopes = other.getOAuthScopes();
        return !(this$oAuthScopes == null ? other$oAuthScopes != null : !((Object)this$oAuthScopes).equals(other$oAuthScopes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isServiceAccount() ? 79 : 97);
        result = result * 59 + (this.isOnlySpinnakerManaged() ? 79 : 97);
        result = result * 59 + (this.isCacheAllApplicationRelationships() ? 79 : 97);
        result = result * 59 + (this.checkPermissionsOnStartup ? 79 : 97);
        result = result * 59 + (this.metrics ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        Integer $kubectlRequestTimeoutSeconds = this.getKubectlRequestTimeoutSeconds();
        result = result * 59 + ($kubectlRequestTimeoutSeconds == null ? 43 : ((Object)$kubectlRequestTimeoutSeconds).hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        ImmutableList<String> $namespaces = this.getNamespaces();
        result = result * 59 + ($namespaces == null ? 43 : $namespaces.hashCode());
        ImmutableList<String> $omitNamespaces = this.getOmitNamespaces();
        result = result * 59 + ($omitNamespaces == null ? 43 : $omitNamespaces.hashCode());
        ImmutableSet<KubernetesKind> $kinds = this.getKinds();
        result = result * 59 + ($kinds == null ? 43 : $kinds.hashCode());
        ImmutableSet<KubernetesKind> $omitKinds = this.getOmitKinds();
        result = result * 59 + ($omitKinds == null ? 43 : $omitKinds.hashCode());
        List<CustomKubernetesResource> $customResources = this.getCustomResources();
        result = result * 59 + ($customResources == null ? 43 : ((Object)$customResources).hashCode());
        String $kubectlExecutable = this.getKubectlExecutable();
        result = result * 59 + ($kubectlExecutable == null ? 43 : $kubectlExecutable.hashCode());
        String $kubeconfigFileHash = this.kubeconfigFileHash;
        result = result * 59 + ($kubeconfigFileHash == null ? 43 : $kubeconfigFileHash.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        RawResourcesEndpointConfig $rawResourcesEndpointConfig = this.getRawResourcesEndpointConfig();
        result = result * 59 + ($rawResourcesEndpointConfig == null ? 43 : ((Object)$rawResourcesEndpointConfig).hashCode());
        List<KubernetesCachingPolicy> $cachingPolicies = this.getCachingPolicies();
        result = result * 59 + ($cachingPolicies == null ? 43 : ((Object)$cachingPolicies).hashCode());
        String $oAuthServiceAccount = this.getOAuthServiceAccount();
        result = result * 59 + ($oAuthServiceAccount == null ? 43 : $oAuthServiceAccount.hashCode());
        List<String> $oAuthScopes = this.getOAuthScopes();
        result = result * 59 + ($oAuthScopes == null ? 43 : ((Object)$oAuthScopes).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public ImmutableList<String> getNamespaces() {
        return this.namespaces;
    }

    @Generated
    public ImmutableList<String> getOmitNamespaces() {
        return this.omitNamespaces;
    }

    @Generated
    public ImmutableSet<KubernetesKind> getKinds() {
        return this.kinds;
    }

    @Generated
    public ImmutableSet<KubernetesKind> getOmitKinds() {
        return this.omitKinds;
    }

    @Generated
    public List<CustomKubernetesResource> getCustomResources() {
        return this.customResources;
    }

    @Generated
    public String getKubectlExecutable() {
        return this.kubectlExecutable;
    }

    @Generated
    public Integer getKubectlRequestTimeoutSeconds() {
        return this.kubectlRequestTimeoutSeconds;
    }

    @Generated
    public String getKubeconfigFile() {
        return this.kubeconfigFile;
    }

    @Generated
    public boolean isServiceAccount() {
        return this.serviceAccount;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public boolean isOnlySpinnakerManaged() {
        return this.onlySpinnakerManaged;
    }

    @Generated
    public boolean isCacheAllApplicationRelationships() {
        return this.cacheAllApplicationRelationships;
    }

    @Generated
    public RawResourcesEndpointConfig getRawResourcesEndpointConfig() {
        return this.rawResourcesEndpointConfig;
    }

    @Generated
    public List<KubernetesCachingPolicy> getCachingPolicies() {
        return this.cachingPolicies;
    }

    @Generated
    public String getOAuthServiceAccount() {
        return this.oAuthServiceAccount;
    }

    @Generated
    public List<String> getOAuthScopes() {
        return this.oAuthScopes;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public ResourcePropertyRegistry getResourcePropertyRegistry() {
        return this.resourcePropertyRegistry;
    }

    @Generated
    public KubernetesSpinnakerKindMap getKubernetesSpinnakerKindMap() {
        return this.kubernetesSpinnakerKindMap;
    }

    @Generated
    public Namer<KubernetesManifest> getNamer() {
        return this.namer;
    }

    @Component
    public static class Factory {
        private final Registry spectatorRegistry;
        private final KubernetesNamerRegistry kubernetesNamerRegistry;
        private final KubectlJobExecutor jobExecutor;
        private final ConfigFileService configFileService;
        private final AccountResourcePropertyRegistry.Factory resourcePropertyRegistryFactory;
        private final KubernetesKindRegistry.Factory kindRegistryFactory;
        private final KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap;
        private final GlobalResourcePropertyRegistry globalResourcePropertyRegistry;

        public KubernetesCredentials build(KubernetesAccountProperties.ManagedAccount managedAccount) {
            NamingStrategy<KubernetesManifest> manifestNamer = this.kubernetesNamerRegistry.get(managedAccount.getNamingStrategy());
            return new KubernetesCredentials(this.spectatorRegistry, this.jobExecutor, managedAccount, this.resourcePropertyRegistryFactory, this.kindRegistryFactory, this.kubernetesSpinnakerKindMap, this.getKubeconfigFile(this.configFileService, managedAccount), (Namer<KubernetesManifest>)manifestNamer, this.globalResourcePropertyRegistry);
        }

        private String getKubeconfigFile(ConfigFileService configFileService, KubernetesAccountProperties.ManagedAccount managedAccount) {
            if (StringUtils.isNotEmpty((CharSequence)managedAccount.getKubeconfigFile())) {
                return configFileService.getLocalPath(managedAccount.getKubeconfigFile());
            }
            if (StringUtils.isNotEmpty((CharSequence)managedAccount.getKubeconfigContents())) {
                return configFileService.getLocalPathForContents(managedAccount.getKubeconfigContents(), managedAccount.getName());
            }
            return "";
        }

        @Generated
        public Factory(Registry spectatorRegistry, KubernetesNamerRegistry kubernetesNamerRegistry, KubectlJobExecutor jobExecutor, ConfigFileService configFileService, AccountResourcePropertyRegistry.Factory resourcePropertyRegistryFactory, KubernetesKindRegistry.Factory kindRegistryFactory, KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap, GlobalResourcePropertyRegistry globalResourcePropertyRegistry) {
            this.spectatorRegistry = spectatorRegistry;
            this.kubernetesNamerRegistry = kubernetesNamerRegistry;
            this.jobExecutor = jobExecutor;
            this.configFileService = configFileService;
            this.resourcePropertyRegistryFactory = resourcePropertyRegistryFactory;
            this.kindRegistryFactory = kindRegistryFactory;
            this.kubernetesSpinnakerKindMap = kubernetesSpinnakerKindMap;
            this.globalResourcePropertyRegistry = globalResourcePropertyRegistry;
        }
    }

    private class PermissionValidator {
        private final Supplier<String> checkNamespace = Suppliers.memoize(this::computeCheckNamespace);
        private final Map<KubernetesKind, Boolean> readableKinds = new ConcurrentHashMap<KubernetesKind, Boolean>();
        private final Supplier<Boolean> metricsReadable = Suppliers.memoize(this::checkMetricsReadable);

        private PermissionValidator() {
        }

        private String getCheckNamespace() {
            return this.checkNamespace.get();
        }

        private String computeCheckNamespace() {
            ImmutableList<String> namespaces = KubernetesCredentials.this.getDeclaredNamespaces();
            if (namespaces.isEmpty()) {
                log.warn("There are no namespaces configured (or loadable) -- please check that the list of 'omitNamespaces' for account '{}' doesn't prevent access from all namespaces in this cluster, or that the cluster is reachable.", (Object)KubernetesCredentials.this.accountName);
                return null;
            }
            return (String)namespaces.get(0);
        }

        private boolean skipPermissionChecks() {
            return !KubernetesCredentials.this.checkPermissionsOnStartup;
        }

        private boolean canReadKind(KubernetesKind kind) {
            if (this.skipPermissionChecks()) {
                return true;
            }
            log.info("Checking if {} is readable in account '{}'...", (Object)kind, (Object)KubernetesCredentials.this.accountName);
            try {
                if (KubernetesCredentials.this.kindRegistry.getKindPropertiesOrDefault(kind).isNamespaced()) {
                    KubernetesCredentials.this.list(kind, this.checkNamespace.get());
                } else {
                    KubernetesCredentials.this.list(kind, null);
                }
                return true;
            }
            catch (Exception e) {
                log.info("Kind {} will not be cached in account '{}' because it cannot be listed.", (Object)kind, (Object)KubernetesCredentials.this.accountName);
                return false;
            }
        }

        private boolean checkMetricsReadable() {
            if (this.skipPermissionChecks()) {
                return true;
            }
            try {
                log.info("Checking if pod metrics are readable for account {}...", (Object)KubernetesCredentials.this.accountName);
                KubernetesCredentials.this.topPod(this.getCheckNamespace(), null);
                return true;
            }
            catch (Exception e) {
                log.warn("Could not read pod metrics in account '{}' for reason: {}", (Object)KubernetesCredentials.this.accountName, (Object)e.getMessage());
                log.debug("Reading logs for account '{}' failed with exception: ", (Object)KubernetesCredentials.this.accountName, (Object)e);
                return false;
            }
        }

        boolean isKindReadable(@Nonnull KubernetesKind kind) {
            return this.readableKinds.computeIfAbsent(kind, this::canReadKind);
        }

        boolean isMetricsReadable() {
            return this.metricsReadable.get();
        }
    }

    public static enum KubernetesKindStatus {
        VALID("Kind [%s] is a valid kind"),
        KIND_NONE("Kind [%s] is invalid"),
        EXPLICITLY_OMITTED_BY_CONFIGURATION("Kind [%s] included in 'omitKinds' of kubernetes account configuration"),
        MISSING_FROM_ALLOWED_KINDS("Kind [%s] missing in 'kinds' of kubernetes account configuration"),
        UNKNOWN("Kind [%s] is has not been registered and is not a valid CRD installed in the cluster"),
        READ_ERROR("Error reading kind [%s]. Please check connectivity and access permissions to the cluster");

        private final String errorMessage;

        private KubernetesKindStatus(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getErrorMessage(KubernetesKind kind) {
            return String.format(this.errorMessage, kind);
        }
    }

    private static class Memoizer<T>
    implements Supplier<T> {
        private static final String CACHE_KEY = "key";
        private final LoadingCache<String, T> cache;

        private Memoizer(Supplier<T> supplier, long expirySeconds, TimeUnit timeUnit) {
            this.cache = Caffeine.newBuilder().refreshAfterWrite(expirySeconds, timeUnit).build(key -> supplier.get());
        }

        @Override
        public T get() {
            return (T)this.cache.get((Object)CACHE_KEY);
        }

        @Nullable
        public T getIfPresent() {
            return (T)this.cache.getIfPresent((Object)CACHE_KEY);
        }

        public static <U> Memoizer<U> memoizeWithExpiration(Supplier<U> supplier, long expirySeconds, TimeUnit timeUnit) {
            return new Memoizer<U>(supplier, expirySeconds, timeUnit);
        }
    }
}

