/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesAccountProperties;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionRepository;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionSource;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(value={"account.storage.enabled", "account.storage.kubernetes.enabled"})
public class KubernetesAccountDefinitionSourceConfiguration {
    @Bean
    @Primary
    public CredentialsDefinitionSource<KubernetesAccountProperties.ManagedAccount> kubernetesAccountSource(AccountDefinitionRepository repository, Optional<List<CredentialsDefinitionSource<KubernetesAccountProperties.ManagedAccount>>> additionalSources, KubernetesAccountProperties accountProperties) {
        return new AccountDefinitionSource(repository, KubernetesAccountProperties.ManagedAccount.class, additionalSources.orElseGet(() -> List.of(accountProperties::getAccounts)));
    }
}

