/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.artifact;

import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.OptionalInt;

@NonnullByDefault
public final class ArtifactConverter {
    private ArtifactConverter() {
    }

    public static Artifact toArtifact(KubernetesManifest manifest, String account, OptionalInt version) {
        String name = manifest.getName();
        String versionString = version.isPresent() ? String.format("v%03d", version.getAsInt()) : "";
        String versionedName = versionString.isEmpty() ? name : String.join((CharSequence)"-", name, versionString);
        return Artifact.builder().type("kubernetes/" + manifest.getKind().toString()).name(name).location(manifest.getNamespace()).version(versionString).reference(versionedName).putMetadata("account", (Object)account).build();
    }
}

