/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.SecurityGroup;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupSummary;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import com.netflix.spinnaker.moniker.Moniker;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.openapi.models.V1NetworkPolicy;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPort;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesSecurityGroup
implements KubernetesResource,
SecurityGroup {
    private static final Logger log = LoggerFactory.getLogger(KubernetesSecurityGroup.class);
    private static final ImmutableSet<KubernetesApiVersion> SUPPORTED_API_VERSIONS = ImmutableSet.of((Object)KubernetesApiVersion.EXTENSIONS_V1BETA1, (Object)KubernetesApiVersion.NETWORKING_K8S_IO_V1BETA1, (Object)KubernetesApiVersion.NETWORKING_K8S_IO_V1);
    private final String account;
    private final String id;
    private final String namespace;
    private final String displayName;
    private final KubernetesApiVersion apiVersion;
    private final KubernetesKind kind;
    private final Map<String, String> labels;
    private final Moniker moniker;
    private final Long createdTime;
    private final Set<Rule> inboundRules;
    private final Set<Rule> outboundRules;

    public String getAccountName() {
        return this.account;
    }

    public SecurityGroupSummary getSummary() {
        return KubernetesSecurityGroupSummary.builder().id(this.id).name(this.id).build();
    }

    private KubernetesSecurityGroup(KubernetesManifest manifest, String key, Moniker moniker, Set<Rule> inboundRules, Set<Rule> outboundRules) {
        this.id = manifest.getFullResourceName();
        this.account = ((Keys.InfrastructureCacheKey)Keys.parseKey(key).get()).getAccount();
        this.kind = manifest.getKind();
        this.apiVersion = manifest.getApiVersion();
        this.displayName = manifest.getName();
        this.namespace = manifest.getNamespace();
        this.labels = ImmutableMap.copyOf(manifest.getLabels());
        this.moniker = moniker;
        this.createdTime = manifest.getCreationTimestampEpochMillis();
        this.inboundRules = inboundRules;
        this.outboundRules = outboundRules;
    }

    public static KubernetesSecurityGroup fromCacheData(CacheData cd) {
        if (cd == null) {
            return null;
        }
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cd);
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        HashSet<Rule> inboundRules = new HashSet();
        HashSet<Rule> outboundRules = new HashSet();
        if (!manifest.getKind().equals(KubernetesKind.NETWORK_POLICY)) {
            log.warn("Unknown security group kind " + manifest.getKind());
        } else if (SUPPORTED_API_VERSIONS.contains((Object)manifest.getApiVersion())) {
            V1NetworkPolicy v1beta1NetworkPolicy = KubernetesCacheDataConverter.getResource(manifest, V1NetworkPolicy.class);
            inboundRules = KubernetesSecurityGroup.inboundRules(v1beta1NetworkPolicy);
            outboundRules = KubernetesSecurityGroup.outboundRules(v1beta1NetworkPolicy);
        } else {
            log.warn("Could not determine (in)/(out)bound rules for " + manifest.getName() + " at version " + manifest.getApiVersion());
        }
        Moniker moniker = KubernetesCacheDataConverter.getMoniker(cd);
        return new KubernetesSecurityGroup(manifest, cd.getId(), moniker, inboundRules, outboundRules);
    }

    private static Set<Rule> inboundRules(V1NetworkPolicy policy) {
        if (policy.getSpec().getIngress() == null) {
            return ImmutableSet.of();
        }
        return policy.getSpec().getIngress().stream().map(V1NetworkPolicyIngressRule::getPorts).filter(Objects::nonNull).flatMap(Collection::stream).map(KubernetesSecurityGroup::fromPolicyPort).collect(Collectors.toSet());
    }

    private static Set<Rule> outboundRules(V1NetworkPolicy policy) {
        if (policy.getSpec().getEgress() == null) {
            return ImmutableSet.of();
        }
        return policy.getSpec().getEgress().stream().map(V1NetworkPolicyEgressRule::getPorts).filter(Objects::nonNull).flatMap(Collection::stream).map(KubernetesSecurityGroup::fromPolicyPort).collect(Collectors.toSet());
    }

    private static Rule fromPolicyPort(V1NetworkPolicyPort policyPort) {
        IntOrString port = policyPort.getPort();
        return new PortRule().setProtocol(policyPort.getProtocol()).setPortRanges(port == null ? null : new TreeSet(ImmutableList.of((Object)((Object)new StringPortRange(port.toString())))));
    }

    public String getName() {
        return this.id;
    }

    public String getRegion() {
        return this.namespace;
    }

    public String getCloudProvider() {
        return "kubernetes";
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public KubernetesApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @Generated
    public KubernetesKind getKind() {
        return this.kind;
    }

    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public Moniker getMoniker() {
        return this.moniker;
    }

    @Override
    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Set<Rule> getInboundRules() {
        return this.inboundRules;
    }

    @Generated
    public Set<Rule> getOutboundRules() {
        return this.outboundRules;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesSecurityGroup)) {
            return false;
        }
        KubernetesSecurityGroup other = (KubernetesSecurityGroup)o;
        Long this$createdTime = this.getCreatedTime();
        Long other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        KubernetesApiVersion this$apiVersion = this.getApiVersion();
        KubernetesApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)this$apiVersion).equals(other$apiVersion)) {
            return false;
        }
        KubernetesKind this$kind = this.getKind();
        KubernetesKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Moniker this$moniker = this.getMoniker();
        Moniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !this$moniker.equals(other$moniker)) {
            return false;
        }
        Set<Rule> this$inboundRules = this.getInboundRules();
        Set<Rule> other$inboundRules = other.getInboundRules();
        if (this$inboundRules == null ? other$inboundRules != null : !((Object)this$inboundRules).equals(other$inboundRules)) {
            return false;
        }
        Set<Rule> this$outboundRules = this.getOutboundRules();
        Set<Rule> other$outboundRules = other.getOutboundRules();
        return !(this$outboundRules == null ? other$outboundRules != null : !((Object)this$outboundRules).equals(other$outboundRules));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        KubernetesApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : ((Object)$apiVersion).hashCode());
        KubernetesKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Moniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : $moniker.hashCode());
        Set<Rule> $inboundRules = this.getInboundRules();
        result = result * 59 + ($inboundRules == null ? 43 : ((Object)$inboundRules).hashCode());
        Set<Rule> $outboundRules = this.getOutboundRules();
        result = result * 59 + ($outboundRules == null ? 43 : ((Object)$outboundRules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesSecurityGroup(account=" + this.getAccount() + ", id=" + this.getId() + ", namespace=" + this.getNamespace() + ", displayName=" + this.getDisplayName() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", labels=" + this.getLabels() + ", moniker=" + this.getMoniker() + ", createdTime=" + this.getCreatedTime() + ", inboundRules=" + this.getInboundRules() + ", outboundRules=" + this.getOutboundRules() + ")";
    }

    public static class StringPortRange
    extends Rule.PortRange {
        protected String startPortName;
        protected String endPortName;

        StringPortRange(String port) {
            try {
                Integer numPort;
                this.startPort = numPort = Integer.valueOf(Integer.parseInt(port));
                this.endPort = numPort;
            }
            catch (Exception e) {
                this.startPortName = port;
                this.endPortName = port;
            }
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringPortRange)) {
                return false;
            }
            StringPortRange other = (StringPortRange)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$startPortName = this.getStartPortName();
            String other$startPortName = other.getStartPortName();
            if (this$startPortName == null ? other$startPortName != null : !this$startPortName.equals(other$startPortName)) {
                return false;
            }
            String this$endPortName = this.getEndPortName();
            String other$endPortName = other.getEndPortName();
            return !(this$endPortName == null ? other$endPortName != null : !this$endPortName.equals(other$endPortName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StringPortRange;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $startPortName = this.getStartPortName();
            result = result * 59 + ($startPortName == null ? 43 : $startPortName.hashCode());
            String $endPortName = this.getEndPortName();
            result = result * 59 + ($endPortName == null ? 43 : $endPortName.hashCode());
            return result;
        }

        @Generated
        public String getStartPortName() {
            return this.startPortName;
        }

        @Generated
        public String getEndPortName() {
            return this.endPortName;
        }

        @Generated
        public StringPortRange setStartPortName(String startPortName) {
            this.startPortName = startPortName;
            return this;
        }

        @Generated
        public StringPortRange setEndPortName(String endPortName) {
            this.endPortName = endPortName;
            return this;
        }

        @Generated
        public String toString() {
            return "KubernetesSecurityGroup.StringPortRange(startPortName=" + this.getStartPortName() + ", endPortName=" + this.getEndPortName() + ")";
        }
    }

    private static class PortRule
    implements Rule {
        @Nullable
        private SortedSet<Rule.PortRange> portRanges;
        @Nullable
        private String protocol;

        @Generated
        public PortRule() {
        }

        @Nullable
        @Generated
        public SortedSet<Rule.PortRange> getPortRanges() {
            return this.portRanges;
        }

        @Nullable
        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public PortRule setPortRanges(@Nullable SortedSet<Rule.PortRange> portRanges) {
            this.portRanges = portRanges;
            return this;
        }

        @Generated
        public PortRule setProtocol(@Nullable String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PortRule)) {
                return false;
            }
            PortRule other = (PortRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SortedSet<Rule.PortRange> this$portRanges = this.getPortRanges();
            SortedSet<Rule.PortRange> other$portRanges = other.getPortRanges();
            if (this$portRanges == null ? other$portRanges != null : !this$portRanges.equals(other$portRanges)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PortRule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SortedSet<Rule.PortRange> $portRanges = this.getPortRanges();
            result = result * 59 + ($portRanges == null ? 43 : $portRanges.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesSecurityGroup.PortRule(portRanges=" + this.getPortRanges() + ", protocol=" + this.getProtocol() + ")";
        }
    }

    private static class KubernetesSecurityGroupSummary
    implements SecurityGroupSummary {
        private String name;
        private String id;

        @Generated
        public static KubernetesSecurityGroupSummaryBuilder builder() {
            return new KubernetesSecurityGroupSummaryBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public KubernetesSecurityGroupSummary setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public KubernetesSecurityGroupSummary setId(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KubernetesSecurityGroupSummary)) {
                return false;
            }
            KubernetesSecurityGroupSummary other = (KubernetesSecurityGroupSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KubernetesSecurityGroupSummary;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesSecurityGroup.KubernetesSecurityGroupSummary(name=" + this.getName() + ", id=" + this.getId() + ")";
        }

        @Generated
        public KubernetesSecurityGroupSummary() {
        }

        @Generated
        public KubernetesSecurityGroupSummary(String name, String id) {
            this.name = name;
            this.id = id;
        }

        @Generated
        public static class KubernetesSecurityGroupSummaryBuilder {
            @Generated
            private String name;
            @Generated
            private String id;

            @Generated
            KubernetesSecurityGroupSummaryBuilder() {
            }

            @Generated
            public KubernetesSecurityGroupSummaryBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public KubernetesSecurityGroupSummaryBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public KubernetesSecurityGroupSummary build() {
                return new KubernetesSecurityGroupSummary(this.name, this.id);
            }

            @Generated
            public String toString() {
                return "KubernetesSecurityGroup.KubernetesSecurityGroupSummary.KubernetesSecurityGroupSummaryBuilder(name=" + this.name + ", id=" + this.id + ")";
            }
        }
    }
}

