/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.annotations.FieldsAreNullableByDefault;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;

@NonnullByDefault
public final class KubernetesCoordinates {
    private final KubernetesKind kind;
    private final String namespace;
    private final String name;

    @ParametersAreNullableByDefault
    private KubernetesCoordinates(@Nonnull KubernetesKind kind, String namespace, String name) {
        this.kind = Objects.requireNonNull(kind);
        this.namespace = Strings.nullToEmpty((String)namespace);
        this.name = Strings.nullToEmpty((String)name);
    }

    public static KubernetesCoordinates fromManifest(KubernetesManifest manifest) {
        return KubernetesCoordinates.builder().kind(manifest.getKind()).namespace(manifest.getNamespace()).name(manifest.getName()).build();
    }

    @Generated
    public static KubernetesCoordinatesBuilder builder() {
        return new KubernetesCoordinatesBuilder();
    }

    @Generated
    public KubernetesCoordinatesBuilder toBuilder() {
        return new KubernetesCoordinatesBuilder().kind(this.kind).namespace(this.namespace).name(this.name);
    }

    @Generated
    public KubernetesKind getKind() {
        return this.kind;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesCoordinates)) {
            return false;
        }
        KubernetesCoordinates other = (KubernetesCoordinates)o;
        KubernetesKind this$kind = this.getKind();
        KubernetesKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KubernetesKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesCoordinates(kind=" + this.getKind() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ")";
    }

    @FieldsAreNullableByDefault
    public static class KubernetesCoordinatesBuilder {
        @Generated
        private KubernetesKind kind;
        @Generated
        private String namespace;
        @Generated
        private String name;
        @Nonnull
        private static final Splitter splitter = Splitter.on((char)' ').limit(3);

        public KubernetesCoordinatesBuilder fullResourceName(String fullResourceName) {
            List parts = splitter.splitToList((CharSequence)fullResourceName);
            if (parts.size() != 2) {
                throw new IllegalArgumentException(String.format("Expected a full resource name of the form <kind> <name>. Got: %s", fullResourceName));
            }
            this.kind = KubernetesKind.fromString((String)parts.get(0));
            this.name = (String)parts.get(1);
            return this;
        }

        @Generated
        KubernetesCoordinatesBuilder() {
        }

        @Generated
        public KubernetesCoordinatesBuilder kind(@Nonnull KubernetesKind kind) {
            this.kind = kind;
            return this;
        }

        @Generated
        public KubernetesCoordinatesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public KubernetesCoordinatesBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public KubernetesCoordinates build() {
            return new KubernetesCoordinates(this.kind, this.namespace, this.name);
        }

        @Generated
        public String toString() {
            return "KubernetesCoordinates.KubernetesCoordinatesBuilder(kind=" + this.kind + ", namespace=" + this.namespace + ", name=" + this.name + ")";
        }
    }
}

