/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class KubernetesApiGroup {
    public static final KubernetesApiGroup NONE = new KubernetesApiGroup("");
    public static final KubernetesApiGroup CORE = new KubernetesApiGroup("core");
    public static final KubernetesApiGroup BATCH = new KubernetesApiGroup("batch");
    public static final KubernetesApiGroup APPS = new KubernetesApiGroup("apps");
    public static final KubernetesApiGroup EXTENSIONS = new KubernetesApiGroup("extensions");
    public static final KubernetesApiGroup STORAGE_K8S_IO = new KubernetesApiGroup("storage.k8s.io");
    public static final KubernetesApiGroup APIEXTENSIONS_K8S_IO = new KubernetesApiGroup("apiextensions.k8s.io");
    public static final KubernetesApiGroup APIREGISTRATION_K8S_IO = new KubernetesApiGroup("apiregistration.k8s.io");
    public static final KubernetesApiGroup AUTOSCALING = new KubernetesApiGroup("autoscaling");
    public static final KubernetesApiGroup ADMISSIONREGISTRATION_K8S_IO = new KubernetesApiGroup("admissionregistration.k8s.io");
    public static final KubernetesApiGroup POLICY = new KubernetesApiGroup("policy");
    public static final KubernetesApiGroup SCHEDULING_K8S_IO = new KubernetesApiGroup("scheduling.k8s.io");
    public static final KubernetesApiGroup SETTINGS_K8S_IO = new KubernetesApiGroup("settings.k8s.io");
    public static final KubernetesApiGroup AUTHORIZATION_K8S_IO = new KubernetesApiGroup("authorization.k8s.io");
    public static final KubernetesApiGroup AUTHENTICATION_K8S_IO = new KubernetesApiGroup("authentication.k8s.io");
    public static final KubernetesApiGroup RBAC_AUTHORIZATION_K8S_IO = new KubernetesApiGroup("rbac.authorization.k8s.io");
    public static final KubernetesApiGroup CERTIFICATES_K8S_IO = new KubernetesApiGroup("certificates.k8s.io");
    public static final KubernetesApiGroup NETWORKING_K8S_IO = new KubernetesApiGroup("networking.k8s.io");
    @Nonnull
    private final String name;
    private static final ImmutableSet<KubernetesApiGroup> NATIVE_GROUPS = ImmutableSet.of((Object)CORE, (Object)BATCH, (Object)APPS, (Object)EXTENSIONS, (Object)STORAGE_K8S_IO, (Object)APIEXTENSIONS_K8S_IO, (Object[])new KubernetesApiGroup[]{APIREGISTRATION_K8S_IO, AUTOSCALING, ADMISSIONREGISTRATION_K8S_IO, POLICY, SCHEDULING_K8S_IO, SETTINGS_K8S_IO, AUTHORIZATION_K8S_IO, AUTHENTICATION_K8S_IO, RBAC_AUTHORIZATION_K8S_IO, CERTIFICATES_K8S_IO, NETWORKING_K8S_IO, NONE});

    private KubernetesApiGroup(@Nonnull String name) {
        this.name = name.toLowerCase();
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public boolean isNativeGroup() {
        return NATIVE_GROUPS.contains((Object)this);
    }

    @JsonCreator
    @Nonnull
    public static KubernetesApiGroup fromString(@Nullable String name) {
        if (name == null) {
            return NONE;
        }
        return new KubernetesApiGroup(name);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesApiGroup)) {
            return false;
        }
        KubernetesApiGroup other = (KubernetesApiGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesApiGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

