/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesSelectorList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;

public interface CanDeploy {
    default public OperationResult deploy(KubernetesCredentials credentials, KubernetesManifest manifest, KubernetesManifestStrategy.DeployStrategy deployStrategy) {
        KubernetesManifest deployedManifest;
        if (manifest.hasGenerateName()) {
            KubernetesManifest result = credentials.create(manifest);
            return new OperationResult().addManifest(result);
        }
        switch (deployStrategy) {
            case RECREATE: {
                try {
                    credentials.delete(manifest.getKind(), manifest.getNamespace(), manifest.getName(), new KubernetesSelectorList(), new V1DeleteOptions());
                }
                catch (KubectlJobExecutor.KubectlException kubectlException) {
                    // empty catch block
                }
                deployedManifest = credentials.deploy(manifest);
                break;
            }
            case REPLACE: {
                deployedManifest = credentials.createOrReplace(manifest);
                break;
            }
            case APPLY: {
                deployedManifest = credentials.deploy(manifest);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown deploy strategy: %s", new Object[]{deployStrategy}));
            }
        }
        return new OperationResult().addManifest(deployedManifest);
    }
}

