/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanRollingRestart;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnstableReason;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnsupportedVersionException;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1DaemonSetStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class KubernetesDaemonSetHandler
extends KubernetesHandler
implements CanResize,
CanPauseRollout,
CanResumeRollout,
CanUndoRollout,
CanRollingRestart,
ServerGroupHandler {
    private static final ImmutableSet<KubernetesApiVersion> SUPPORTED_API_VERSIONS = ImmutableSet.of((Object)KubernetesApiVersion.APPS_V1);

    @Override
    @Nonnull
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.dockerImage(), (Object)Replacer.configMapVolume(), (Object)Replacer.secretVolume(), (Object)Replacer.configMapProjectedVolume(), (Object)Replacer.secretProjectedVolume(), (Object)Replacer.configMapEnv(), (Object)Replacer.secretEnv(), (Object)Replacer.configMapKeyValue(), (Object)Replacer.secretKeyValue());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.DAEMON_SET;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        if (!SUPPORTED_API_VERSIONS.contains((Object)manifest.getApiVersion())) {
            throw new UnsupportedVersionException(manifest);
        }
        V1DaemonSet v1DaemonSet = KubernetesCacheDataConverter.getResource(manifest, V1DaemonSet.class);
        return this.status(v1DaemonSet);
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key) {
        Map<String, Object> result = super.hydrateSearchResult(key);
        result.put("serverGroup", result.get("name"));
        return result;
    }

    private Manifest.Status status(V1DaemonSet daemonSet) {
        int existing;
        V1DaemonSetStatus status = daemonSet.getStatus();
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        if (!this.generationMatches(daemonSet, status)) {
            return Manifest.Status.defaultStatus().unstable(UnstableReason.OLD_GENERATION.getMessage());
        }
        if (!daemonSet.getSpec().getUpdateStrategy().getType().equalsIgnoreCase("rollingupdate")) {
            return Manifest.Status.defaultStatus();
        }
        Long observedGeneration = status.getObservedGeneration();
        if (observedGeneration != null && !observedGeneration.equals(daemonSet.getMetadata().getGeneration())) {
            return Manifest.Status.defaultStatus().unstable("Waiting for daemonset spec update to be observed");
        }
        int desiredReplicas = this.defaultToZero(status.getDesiredNumberScheduled());
        if (desiredReplicas > (existing = this.defaultToZero(status.getCurrentNumberScheduled()))) {
            return Manifest.Status.defaultStatus().unstable("Waiting for all replicas to be scheduled");
        }
        existing = this.defaultToZero(status.getUpdatedNumberScheduled());
        if (desiredReplicas > existing) {
            return Manifest.Status.defaultStatus().unstable("Waiting for all updated replicas to be scheduled");
        }
        existing = this.defaultToZero(status.getNumberAvailable());
        if (desiredReplicas > existing) {
            return Manifest.Status.defaultStatus().unstable("Waiting for all replicas to be available");
        }
        existing = this.defaultToZero(status.getNumberReady());
        if (desiredReplicas > existing) {
            return Manifest.Status.defaultStatus().unstable("Waiting for all replicas to be ready");
        }
        return Manifest.Status.defaultStatus();
    }

    private boolean generationMatches(V1DaemonSet daemonSet, V1DaemonSetStatus status) {
        Optional<Long> metadataGeneration = Optional.ofNullable(daemonSet.getMetadata()).map(V1ObjectMeta::getGeneration);
        Optional<Long> statusGeneration = Optional.ofNullable(status.getObservedGeneration());
        return statusGeneration.isPresent() && statusGeneration.equals(metadataGeneration);
    }

    private int defaultToZero(@Nullable Integer input) {
        return input == null ? 0 : input;
    }
}

