/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanReceiveTraffic;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class KubernetesPodHandler
extends KubernetesHandler
implements CanReceiveTraffic {
    @Override
    @Nonnull
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.podDockerImage());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.POD;
    }

    @Override
    public boolean versioned() {
        return true;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.INSTANCES;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V1PodStatus status = KubernetesCacheDataConverter.getResource(manifest.getStatus(), V1PodStatus.class);
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        PodPhase phase = PodPhase.fromString(status.getPhase());
        if (phase.isUnstable()) {
            return Manifest.Status.defaultStatus().unstable(phase.getMessage()).unavailable(phase.getMessage());
        }
        return Manifest.Status.defaultStatus();
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key) {
        Map<String, Object> result = super.hydrateSearchResult(key);
        result.put("instanceId", result.get("name"));
        return result;
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    private static enum PodPhase {
        Pending(true, "Pod is pending"),
        Running(false, ""),
        Succeeded(false, ""),
        Failed(true, "Pod has failed"),
        Unknown(true, "Pod phase is unknown");

        private final String message;
        private final boolean unstable;

        private PodPhase(boolean unstable, String message) {
            this.message = message;
            this.unstable = unstable;
        }

        static PodPhase fromString(@Nullable String phase) {
            if (phase == null) {
                return Unknown;
            }
            try {
                return PodPhase.valueOf(phase);
            }
            catch (IllegalArgumentException e) {
                return Unknown;
            }
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public boolean isUnstable() {
            return this.unstable;
        }
    }
}

