/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestSelector;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.HasPods;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnstableReason;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.UnsupportedVersionException;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicaSetSpec;
import io.kubernetes.client.openapi.models.V1ReplicaSetStatus;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
public class KubernetesReplicaSetHandler
extends KubernetesHandler
implements CanResize,
CanScale,
HasPods,
ServerGroupHandler {
    private static final ImmutableSet<KubernetesApiVersion> SUPPORTED_API_VERSIONS = ImmutableSet.of((Object)KubernetesApiVersion.APPS_V1);

    @Override
    protected ImmutableList<Replacer> artifactReplacers() {
        return ImmutableList.of((Object)Replacer.dockerImage(), (Object)Replacer.configMapVolume(), (Object)Replacer.secretVolume(), (Object)Replacer.configMapProjectedVolume(), (Object)Replacer.secretProjectedVolume(), (Object)Replacer.configMapEnv(), (Object)Replacer.secretEnv(), (Object)Replacer.configMapKeyValue(), (Object)Replacer.secretKeyValue());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.REPLICA_SET;
    }

    @Override
    public boolean versioned() {
        return true;
    }

    @Override
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        if (!SUPPORTED_API_VERSIONS.contains((Object)manifest.getApiVersion())) {
            throw new UnsupportedVersionException(manifest);
        }
        V1ReplicaSet v1ReplicaSet = KubernetesCacheDataConverter.getResource(manifest, V1ReplicaSet.class);
        return this.status(v1ReplicaSet);
    }

    private Manifest.Status status(V1ReplicaSet replicaSet) {
        V1ReplicaSetStatus status = replicaSet.getStatus();
        if (status == null) {
            return Manifest.Status.noneReported();
        }
        Optional<UnstableReason> unstableReason = this.checkReplicaCounts(replicaSet, status);
        if (unstableReason.isPresent()) {
            return Manifest.Status.defaultStatus().unstable(unstableReason.get().getMessage()).unavailable(unstableReason.get().getMessage());
        }
        if (!this.generationMatches(replicaSet, status)) {
            return Manifest.Status.defaultStatus().unstable("Waiting for replicaset spec update to be observed");
        }
        return Manifest.Status.defaultStatus();
    }

    private Optional<UnstableReason> checkReplicaCounts(V1ReplicaSet replicaSet, V1ReplicaSetStatus status) {
        int desired = Optional.ofNullable(replicaSet.getSpec()).map(V1ReplicaSetSpec::getReplicas).orElse(0);
        int fullyLabeled = KubernetesReplicaSetHandler.defaultToZero(status.getFullyLabeledReplicas());
        int available = KubernetesReplicaSetHandler.defaultToZero(status.getAvailableReplicas());
        int ready = KubernetesReplicaSetHandler.defaultToZero(status.getReadyReplicas());
        if (desired > fullyLabeled) {
            return Optional.of(UnstableReason.FULLY_LABELED_REPLICAS);
        }
        if (desired > ready) {
            return Optional.of(UnstableReason.READY_REPLICAS);
        }
        if (desired > available) {
            return Optional.of(UnstableReason.AVAILABLE_REPLICAS);
        }
        return Optional.empty();
    }

    private static int defaultToZero(@Nullable Integer input) {
        return input == null ? 0 : input;
    }

    private boolean generationMatches(V1ReplicaSet replicaSet, V1ReplicaSetStatus status) {
        Optional<Long> metadataGeneration = Optional.ofNullable(replicaSet.getMetadata()).map(V1ObjectMeta::getGeneration);
        Optional<Long> statusGeneration = Optional.ofNullable(status.getObservedGeneration());
        return statusGeneration.isPresent() && statusGeneration.equals(metadataGeneration);
    }

    public static Map<String, String> getPodTemplateLabels(KubernetesManifest manifest) {
        if (manifest.getApiVersion().equals(KubernetesApiVersion.APPS_V1)) {
            V1ReplicaSet v1ReplicaSet = KubernetesCacheDataConverter.getResource(manifest, V1ReplicaSet.class);
            return KubernetesReplicaSetHandler.getPodTemplateLabels(v1ReplicaSet);
        }
        throw new UnsupportedVersionException(manifest);
    }

    private static Map<String, String> getPodTemplateLabels(V1ReplicaSet replicaSet) {
        return replicaSet.getSpec().getTemplate().getMetadata().getLabels();
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key) {
        Map<String, Object> result = super.hydrateSearchResult(key);
        result.put("serverGroup", result.get("name"));
        return result;
    }

    @Override
    public List<KubernetesManifest> pods(KubernetesCredentials credentials, KubernetesManifest object) {
        KubernetesManifestSelector selector = object.getManifestSelector();
        return credentials.list(KubernetesKind.POD, object.getNamespace(), selector.toSelectorList()).stream().filter(p -> p.getOwnerReferences().stream().anyMatch(or -> or.getName().equals(object.getName()))).collect(Collectors.toList());
    }
}

