/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.model.Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanLoadBalance;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesReplicaSetHandler;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KubernetesServiceHandler
extends KubernetesHandler
implements CanLoadBalance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesServiceHandler.class);

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.NETWORK_RESOURCE_PRIORITY.getValue();
    }

    @Override
    @Nonnull
    public KubernetesKind kind() {
        return KubernetesKind.SERVICE;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    @Nonnull
    public SpinnakerKind spinnakerKind() {
        return SpinnakerKind.LOAD_BALANCERS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        return Manifest.Status.defaultStatus();
    }

    @Override
    protected KubernetesCachingAgentFactory cachingAgentFactory() {
        return KubernetesCoreCachingAgent::new;
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key) {
        Map<String, Object> result = super.hydrateSearchResult(key);
        result.put("loadBalancer", result.get("name"));
        return result;
    }

    @Override
    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        HashMap<String, Set<KubernetesManifest>> mapLabelToManifest = new HashMap<String, Set<KubernetesManifest>>();
        ((List)allResources.getOrDefault(KubernetesKind.REPLICA_SET, new ArrayList())).forEach(r -> this.addAllReplicaSetLabels((Map<String, Set<KubernetesManifest>>)mapLabelToManifest, (KubernetesManifest)r));
        for (KubernetesManifest service : (List)allResources.getOrDefault(KubernetesKind.SERVICE, new ArrayList())) {
            relationshipMap.put(service, this.getRelatedManifests(service, mapLabelToManifest));
        }
    }

    @Nonnull
    private ImmutableMap<String, String> getSelector(KubernetesManifest manifest) {
        if (manifest.getApiVersion().equals(KubernetesApiVersion.V1)) {
            V1Service v1Service = KubernetesCacheDataConverter.getResource(manifest, V1Service.class);
            if (v1Service.getSpec() == null || v1Service.getSpec().getSelector() == null) {
                return ImmutableMap.of();
            }
            return ImmutableMap.copyOf((Map)v1Service.getSpec().getSelector());
        }
        throw new IllegalArgumentException("No services with version " + manifest.getApiVersion() + " supported");
    }

    private List<KubernetesManifest> getRelatedManifests(KubernetesManifest service, Map<String, Set<KubernetesManifest>> mapLabelToManifest) {
        return new ArrayList<KubernetesManifest>(this.intersectLabels(service, mapLabelToManifest));
    }

    private Set<KubernetesManifest> intersectLabels(KubernetesManifest service, Map<String, Set<KubernetesManifest>> mapLabelToManifest) {
        ImmutableMap<String, String> selector = this.getSelector(service);
        if (selector.isEmpty()) {
            return new HashSet<KubernetesManifest>();
        }
        HashSet result = null;
        String namespace = service.getNamespace();
        for (Map.Entry label : selector.entrySet()) {
            String labelKey = this.podLabelKey(namespace, label);
            HashSet manifests = mapLabelToManifest.get(labelKey);
            HashSet hashSet = manifests = manifests == null ? new HashSet() : manifests;
            if (result == null) {
                result = manifests;
                continue;
            }
            result.retainAll(manifests);
        }
        return result;
    }

    private void addAllReplicaSetLabels(Map<String, Set<KubernetesManifest>> entries, KubernetesManifest replicaSet) {
        String namespace = replicaSet.getNamespace();
        Map<String, String> podLabels = KubernetesReplicaSetHandler.getPodTemplateLabels(replicaSet);
        if (podLabels == null) {
            return;
        }
        for (Map.Entry<String, String> label : podLabels.entrySet()) {
            String labelKey = this.podLabelKey(namespace, label);
            this.enterManifest(entries, labelKey, KubernetesCacheDataConverter.convertToManifest(replicaSet));
        }
    }

    private void enterManifest(Map<String, Set<KubernetesManifest>> entries, String label, KubernetesManifest manifest) {
        Set<KubernetesManifest> pods = entries.get(label);
        if (pods == null) {
            pods = new HashSet<KubernetesManifest>();
        }
        pods.add(manifest);
        entries.put(label, pods);
    }

    private String podLabelKey(String namespace, Map.Entry<String, String> label) {
        return namespace + " " + label.getKey() + " " + label.getValue();
    }

    @Override
    @ParametersAreNonnullByDefault
    public void attach(KubernetesManifest loadBalancer, KubernetesManifest target) {
        KubernetesCoordinates loadBalancerCoords = KubernetesCoordinates.fromManifest(loadBalancer);
        if (loadBalancerCoords.equals(KubernetesCoordinates.fromManifest(target))) {
            log.warn("Adding traffic selection labels to service {}, which itself is the source load balancer. This may change in the future.", (Object)loadBalancerCoords);
        }
        Map<String, String> labels = target.getSpecTemplateLabels().orElse(target.getLabels());
        ImmutableMap<String, String> selector = this.getSelector(loadBalancer);
        if (selector.isEmpty()) {
            throw new IllegalArgumentException("Service must have a non-empty selector in order to be attached to a workload");
        }
        if (!Collections.disjoint(labels.keySet(), selector.keySet())) {
            throw new IllegalArgumentException("Service selector must have no label keys in common with target workload");
        }
        labels.putAll((Map<String, String>)selector);
    }

    private String pathPrefix(KubernetesManifest target) {
        if (target.getSpecTemplateLabels().isPresent()) {
            return "/spec/template/metadata/labels";
        }
        return "/metadata/labels";
    }

    private Map<String, String> labels(KubernetesManifest target) {
        if (target.getSpecTemplateLabels().isPresent()) {
            return target.getSpecTemplateLabels().get();
        }
        return target.getLabels();
    }

    @Override
    @ParametersAreNonnullByDefault
    public List<JsonPatch> attachPatch(KubernetesManifest loadBalancer, KubernetesManifest target) {
        String pathPrefix = this.pathPrefix(target);
        Map<String, String> labels = this.labels(target);
        return this.getSelector(loadBalancer).entrySet().stream().map(kv -> JsonPatch.builder().op(labels.containsKey(kv.getKey()) ? JsonPatch.Op.replace : JsonPatch.Op.add).path(String.join((CharSequence)"/", pathPrefix, JsonPatch.escapeNode((String)kv.getKey()))).value(kv.getValue()).build()).collect(Collectors.toList());
    }

    @Override
    @ParametersAreNonnullByDefault
    public List<JsonPatch> detachPatch(KubernetesManifest loadBalancer, KubernetesManifest target) {
        String pathPrefix = this.pathPrefix(target);
        Map<String, String> labels = this.labels(target);
        return this.getSelector(loadBalancer).keySet().stream().filter(labels::containsKey).map(k -> JsonPatch.builder().op(JsonPatch.Op.remove).path(String.join((CharSequence)"/", pathPrefix, JsonPatch.escapeNode(k))).build()).collect(Collectors.toList());
    }
}

