/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

class ArtifactKey {
    private final String type;
    private final String name;
    private final String version;
    private final String location;
    private final String reference;

    private ArtifactKey(Artifact artifact) {
        this.type = artifact.getType();
        this.name = artifact.getName();
        this.version = artifact.getVersion();
        this.location = artifact.getLocation();
        this.reference = artifact.getReference();
    }

    @Nonnull
    static ArtifactKey fromArtifact(@Nonnull Artifact artifact) {
        return new ArtifactKey(artifact);
    }

    @Nonnull
    static ImmutableSet<ArtifactKey> fromArtifacts(@Nullable Collection<Artifact> artifacts) {
        if (artifacts == null) {
            return ImmutableSet.of();
        }
        return (ImmutableSet)artifacts.stream().filter(Objects::nonNull).map(ArtifactKey::fromArtifact).collect(ImmutableSet.toImmutableSet());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey other = (ArtifactKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$location = this.location;
        String other$location = other.location;
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$reference = this.reference;
        String other$reference = other.reference;
        return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArtifactKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $location = this.location;
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $reference = this.reference;
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArtifactKey(type=" + this.type + ", name=" + this.name + ", version=" + this.version + ", location=" + this.location + ", reference=" + this.reference + ")";
    }
}

