/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ResourceVersioner;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestTraffic;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesSourceCapacity;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanLoadBalance;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanReceiveTraffic;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.manifest.ArtifactKey;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeployManifestOperation
implements AtomicOperation<OperationResult> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesDeployManifestOperation.class);
    private final KubernetesDeployManifestDescription description;
    private final KubernetesCredentials credentials;
    private final ResourceVersioner resourceVersioner;
    @Nonnull
    private final String accountName;
    private static final String OP_NAME = "DEPLOY_KUBERNETES_MANIFEST";

    public KubernetesDeployManifestOperation(KubernetesDeployManifestDescription description, ResourceVersioner resourceVersioner) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
        this.resourceVersioner = resourceVersioner;
        this.accountName = description.getCredentials().getName();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List<OperationResult> _unused) {
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Beginning deployment of manifest...");
        List<KubernetesManifest> inputManifests = this.getManifestsFromDescription();
        this.sortManifests(inputManifests);
        Map<String, Artifact> allArtifacts = this.initializeArtifacts();
        OperationResult result = new OperationResult();
        List<ManifestArtifactHolder> toDeploy = inputManifests.stream().map(manifest -> {
            Integer replicas;
            KubernetesManifestAnnotater.validateAnnotationsForRolloutStrategies(manifest, this.description.getStrategy());
            manifest = this.bindArtifacts((KubernetesManifest)manifest, allArtifacts.values(), result);
            KubernetesResourceProperties properties = this.findResourceProperties((KubernetesManifest)manifest);
            KubernetesManifestStrategy strategy = KubernetesManifestAnnotater.getStrategy(manifest);
            OptionalInt version = this.isVersioned(properties, strategy) ? this.resourceVersioner.getVersion((KubernetesManifest)manifest, this.credentials) : OptionalInt.empty();
            Moniker moniker = KubernetesDeployManifestOperation.cloneMoniker(this.description.getMoniker());
            version.ifPresent(arg_0 -> ((Moniker)moniker).setSequence(arg_0));
            if (Strings.isNullOrEmpty((String)moniker.getCluster())) {
                moniker.setCluster(manifest.getFullResourceName());
            }
            Artifact artifact = ArtifactConverter.toArtifact(manifest, this.description.getAccount(), version);
            allArtifacts.put(this.getArtifactKey(artifact), artifact);
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Annotating manifest " + manifest.getFullResourceName() + " with artifact, relationships & moniker...");
            KubernetesManifestAnnotater.annotateManifest(manifest, artifact);
            KubernetesHandler deployer = properties.getHandler();
            if (strategy.isUseSourceCapacity() && deployer instanceof CanScale && (replicas = KubernetesSourceCapacity.getSourceCapacity(manifest, this.credentials)) != null) {
                manifest.setReplicas(replicas);
            }
            if (deployer instanceof CanReceiveTraffic) {
                this.setTrafficAnnotation(this.description.getServices(), (KubernetesManifest)manifest);
                if (this.description.isEnableTraffic()) {
                    KubernetesManifestTraffic traffic = KubernetesManifestAnnotater.getTraffic(manifest);
                    this.applyTraffic(traffic, (KubernetesManifest)manifest, (Collection<KubernetesManifest>)inputManifests);
                }
            }
            this.credentials.getNamer().applyMoniker(manifest, moniker);
            manifest.setName(artifact.getReference());
            return new ManifestArtifactHolder((KubernetesManifest)manifest, artifact, strategy);
        }).collect(Collectors.toList());
        this.checkIfArtifactsBound(result);
        toDeploy.forEach(holder -> {
            KubernetesResourceProperties properties = this.findResourceProperties(holder.manifest);
            KubernetesManifestStrategy strategy = holder.strategy;
            KubernetesHandler deployer = properties.getHandler();
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Submitting manifest " + holder.manifest.getFullResourceName() + " to kubernetes master...");
            log.debug("Manifest in {} to be deployed: {}", (Object)this.accountName, (Object)holder.manifest);
            result.merge(deployer.deploy(this.credentials, holder.manifest, strategy.getDeployStrategy()));
            result.getCreatedArtifacts().add(holder.artifact);
        });
        result.removeSensitiveKeys(this.credentials.getResourcePropertyRegistry());
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Deploy manifest task completed successfully.");
        return result;
    }

    @NotNull
    private List<KubernetesManifest> getManifestsFromDescription() {
        Object inputManifests = this.description.getManifests();
        if (inputManifests == null || inputManifests.isEmpty()) {
            KubernetesManifest manifest = this.description.getManifest();
            log.warn("Relying on deprecated single manifest input (account: {}, kind: {}, name: {})", new Object[]{this.accountName, manifest.getKind(), manifest.getName()});
            inputManifests = ImmutableList.of((Object)manifest);
        }
        inputManifests = inputManifests.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return inputManifests;
    }

    @NotNull
    private Map<String, Artifact> initializeArtifacts() {
        HashMap<String, Artifact> allArtifacts = new HashMap<String, Artifact>();
        if (!this.description.isEnableArtifactBinding()) {
            return allArtifacts;
        }
        if (this.description.getRequiredArtifacts() != null) {
            this.description.getRequiredArtifacts().forEach(a -> allArtifacts.putIfAbsent(this.getArtifactKey((Artifact)a), (Artifact)a));
        }
        if (this.description.getOptionalArtifacts() != null) {
            this.description.getOptionalArtifacts().forEach(a -> allArtifacts.putIfAbsent(this.getArtifactKey((Artifact)a), (Artifact)a));
        }
        return allArtifacts;
    }

    private KubernetesManifest bindArtifacts(KubernetesManifest manifest, Collection<Artifact> artifacts, OperationResult operationResult) {
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Binding artifacts in " + manifest.getFullResourceName() + "...");
        ArtifactReplacer.ReplaceResult replaceResult = this.findResourceProperties(manifest).getHandler().replaceArtifacts(manifest, List.copyOf(artifacts), this.description.getAccount());
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Bound artifacts: " + replaceResult.getBoundArtifacts() + "...");
        operationResult.getBoundArtifacts().addAll((Collection<Artifact>)replaceResult.getBoundArtifacts());
        return replaceResult.getManifest();
    }

    private void checkIfArtifactsBound(OperationResult operationResult) {
        Sets.SetView unboundArtifacts;
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Checking if all requested artifacts were bound...");
        if (this.description.isEnableArtifactBinding() && !(unboundArtifacts = Sets.difference(ArtifactKey.fromArtifacts(this.description.getRequiredArtifacts()), ArtifactKey.fromArtifacts(operationResult.getBoundArtifacts()))).isEmpty()) {
            throw new IllegalArgumentException(String.format("The following required artifacts could not be bound: '%s'. Check that the Docker image name above matches the name used in the image field of your manifest. Failing the stage as this is likely a configuration error.", unboundArtifacts));
        }
    }

    private void sortManifests(List<KubernetesManifest> manifests) {
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Sorting manifests by priority...");
        manifests.sort(Comparator.comparingInt(m -> this.findResourceProperties((KubernetesManifest)m).getHandler().deployPriority()));
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Deploy order is: " + manifests.stream().map(KubernetesManifest::getFullResourceName).collect(Collectors.joining(", ")));
    }

    private String getArtifactKey(Artifact artifact) {
        return String.format("[%s]-[%s]-[%s]", artifact.getType(), artifact.getName(), artifact.getLocation() != null ? artifact.getLocation() : "");
    }

    private void setTrafficAnnotation(List<String> services, KubernetesManifest manifest) {
        if (services == null || services.isEmpty()) {
            return;
        }
        KubernetesManifestTraffic traffic = new KubernetesManifestTraffic(services);
        KubernetesManifestAnnotater.setTraffic(manifest, traffic);
    }

    private void applyTraffic(KubernetesManifestTraffic traffic, KubernetesManifest target, Collection<KubernetesManifest> manifestsFromRequest) {
        traffic.getLoadBalancers().forEach(l -> this.attachLoadBalancer((String)l, target, manifestsFromRequest));
    }

    private void attachLoadBalancer(String loadBalancerName, KubernetesManifest target, Collection<KubernetesManifest> manifestsFromRequest) {
        KubernetesCoordinates coords;
        try {
            coords = KubernetesCoordinates.builder().namespace(target.getNamespace()).fullResourceName(loadBalancerName).build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Failed to attach load balancer '%s'. Load balancers must be specified in the form '{kind} {name}', e.g. 'service my-service'.", loadBalancerName), e);
        }
        KubernetesManifest loadBalancer = this.getLoadBalancer(coords, manifestsFromRequest);
        CanLoadBalance handler = CanLoadBalance.lookupProperties(this.credentials.getResourcePropertyRegistry(), coords);
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Attaching load balancer " + loadBalancer.getFullResourceName() + " to " + target.getFullResourceName());
        handler.attach(loadBalancer, target);
    }

    private KubernetesManifest getLoadBalancer(KubernetesCoordinates coords, Collection<KubernetesManifest> manifestsFromRequest) {
        Optional<KubernetesManifest> loadBalancer = manifestsFromRequest.stream().filter(m -> KubernetesCoordinates.fromManifest(m).equals(coords)).findFirst();
        return loadBalancer.orElseGet(() -> Optional.ofNullable(this.credentials.get(coords)).orElseThrow(() -> new IllegalArgumentException("Load balancer " + coords.getKind().toString() + " " + coords.getName() + " does not exist")));
    }

    private boolean isVersioned(KubernetesResourceProperties properties, KubernetesManifestStrategy strategy) {
        if (strategy.getVersioned() != KubernetesManifestStrategy.Versioned.DEFAULT) {
            return strategy.getVersioned() == KubernetesManifestStrategy.Versioned.TRUE;
        }
        if (this.description.getVersioned() != null) {
            return this.description.getVersioned();
        }
        return properties.isVersioned();
    }

    private static Moniker cloneMoniker(Moniker inp) {
        return Moniker.builder().app(inp.getApp()).cluster(inp.getCluster()).stack(inp.getStack()).detail(inp.getDetail()).sequence(inp.getSequence()).build();
    }

    @Nonnull
    private KubernetesResourceProperties findResourceProperties(KubernetesManifest manifest) {
        KubernetesKind kind = manifest.getKind();
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Finding deployer for " + kind + "...");
        return this.credentials.getResourcePropertyRegistry().get(kind);
    }

    private static class ManifestArtifactHolder {
        @Nonnull
        private KubernetesManifest manifest;
        @Nonnull
        private Artifact artifact;
        @Nonnull
        private KubernetesManifestStrategy strategy;

        @Nonnull
        @Generated
        public KubernetesManifest getManifest() {
            return this.manifest;
        }

        @Nonnull
        @Generated
        public Artifact getArtifact() {
            return this.artifact;
        }

        @Nonnull
        @Generated
        public KubernetesManifestStrategy getStrategy() {
            return this.strategy;
        }

        @Generated
        public ManifestArtifactHolder setManifest(@Nonnull KubernetesManifest manifest) {
            if (manifest == null) {
                throw new IllegalArgumentException("manifest is marked non-null but is null");
            }
            this.manifest = manifest;
            return this;
        }

        @Generated
        public ManifestArtifactHolder setArtifact(@Nonnull Artifact artifact) {
            if (artifact == null) {
                throw new IllegalArgumentException("artifact is marked non-null but is null");
            }
            this.artifact = artifact;
            return this;
        }

        @Generated
        public ManifestArtifactHolder setStrategy(@Nonnull KubernetesManifestStrategy strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException("strategy is marked non-null but is null");
            }
            this.strategy = strategy;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManifestArtifactHolder)) {
                return false;
            }
            ManifestArtifactHolder other = (ManifestArtifactHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            KubernetesManifest this$manifest = this.getManifest();
            KubernetesManifest other$manifest = other.getManifest();
            if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
                return false;
            }
            Artifact this$artifact = this.getArtifact();
            Artifact other$artifact = other.getArtifact();
            if (this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact)) {
                return false;
            }
            KubernetesManifestStrategy this$strategy = this.getStrategy();
            KubernetesManifestStrategy other$strategy = other.getStrategy();
            return !(this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ManifestArtifactHolder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KubernetesManifest $manifest = this.getManifest();
            result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
            Artifact $artifact = this.getArtifact();
            result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
            KubernetesManifestStrategy $strategy = this.getStrategy();
            result = result * 59 + ($strategy == null ? 43 : ((Object)$strategy).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesDeployManifestOperation.ManifestArtifactHolder(manifest=" + this.getManifest() + ", artifact=" + this.getArtifact() + ", strategy=" + this.getStrategy() + ")";
        }

        @Generated
        public ManifestArtifactHolder(@Nonnull KubernetesManifest manifest, @Nonnull Artifact artifact, @Nonnull KubernetesManifestStrategy strategy) {
            if (manifest == null) {
                throw new IllegalArgumentException("manifest is marked non-null but is null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("artifact is marked non-null but is null");
            }
            if (strategy == null) {
                throw new IllegalArgumentException("strategy is marked non-null but is null");
            }
            this.manifest = manifest;
            this.artifact = artifact;
            this.strategy = strategy;
        }
    }
}

