/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesPatchManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.manifest.ArtifactKey;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KubernetesPatchManifestOperation
implements AtomicOperation<OperationResult> {
    private final KubernetesPatchManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "PATCH_KUBERNETES_MANIFEST";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public KubernetesPatchManifestOperation(KubernetesPatchManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List<OperationResult> _unused) {
        this.updateStatus("Beginning patching of manifest");
        KubernetesCoordinates objToPatch = this.description.getPointCoordinates();
        this.updateStatus("Finding patch handler for " + objToPatch + "...");
        KubernetesHandler patchHandler = this.findPatchHandler(objToPatch);
        OperationResult result = new OperationResult();
        KubernetesPatchOptions.MergeStrategy mergeStrategy = this.description.getOptions().getMergeStrategy();
        if (mergeStrategy == KubernetesPatchOptions.MergeStrategy.json) {
            this.updateStatus("Submitting manifest " + this.description.getManifestName() + " to Kubernetes master...");
            List jsonPatches = (List)objectMapper.convertValue(this.description.getPatchBody(), (TypeReference)new TypeReference<List<JsonPatch>>(){});
            result.merge(patchHandler.patchWithJson(this.credentials, objToPatch.getNamespace(), objToPatch.getName(), this.description.getOptions(), jsonPatches));
        } else {
            this.updateStatus("Swapping out artifacts in " + objToPatch + " from context...");
            ArtifactReplacer.ReplaceResult replaceResult = this.replaceArtifacts(objToPatch, patchHandler);
            this.updateStatus("Submitting manifest " + this.description.getManifestName() + " to Kubernetes master...");
            result.merge(patchHandler.patchWithManifest(this.credentials, objToPatch.getNamespace(), objToPatch.getName(), this.description.getOptions(), replaceResult.getManifest()));
            result.getBoundArtifacts().addAll((Collection<Artifact>)replaceResult.getBoundArtifacts());
        }
        result.removeSensitiveKeys(this.credentials.getResourcePropertyRegistry());
        return result;
    }

    private void updateStatus(String status) {
        KubernetesPatchManifestOperation.getTask().updateStatus(OP_NAME, status);
    }

    private ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesCoordinates objToPatch, KubernetesHandler patchHandler) {
        Sets.SetView unboundArtifacts;
        ArrayList<Artifact> allArtifacts = this.description.getAllArtifacts() == null ? new ArrayList() : this.description.getAllArtifacts();
        KubernetesManifest manifest = (KubernetesManifest)objectMapper.convertValue(this.description.getPatchBody(), KubernetesManifest.class);
        ArtifactReplacer.ReplaceResult replaceResult = patchHandler.replaceArtifacts(manifest, allArtifacts, Strings.nullToEmpty((String)objToPatch.getNamespace()), this.description.getAccount());
        if (this.description.getRequiredArtifacts() != null && !(unboundArtifacts = Sets.difference(ArtifactKey.fromArtifacts(this.description.getRequiredArtifacts()), ArtifactKey.fromArtifacts(replaceResult.getBoundArtifacts()))).isEmpty()) {
            throw new IllegalArgumentException(String.format("The following required artifacts could not be bound: '%s'.Check that the Docker image name above matches the name used in the image field of your manifest.Failing the stage as this is likely a configuration error.", unboundArtifacts));
        }
        return replaceResult;
    }

    private KubernetesHandler findPatchHandler(KubernetesCoordinates objToPatch) {
        return this.credentials.getResourcePropertyRegistry().get(objToPatch.getKind()).getHandler();
    }
}

