/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesScaleManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesScaleManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesScaleManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "SCALE_KUBERNETES_MANIFEST";

    public KubernetesScaleManifestOperation(KubernetesScaleManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        KubernetesScaleManifestOperation.getTask().updateStatus(OP_NAME, "Starting scale operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesScaleManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(coordinates.getKind()).getHandler();
        if (!(deployer instanceof CanScale)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support scale");
        }
        CanScale canScale = (CanScale)((Object)deployer);
        KubernetesScaleManifestOperation.getTask().updateStatus(OP_NAME, "Calling scale operation...");
        canScale.scale(this.credentials, coordinates.getNamespace(), coordinates.getName(), this.description.getReplicas());
        return null;
    }
}

