/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.validator.manifest;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeleteManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="deleteManifest")
@Component
public class KubernetesDeleteManifestValidator
extends DescriptionValidator<KubernetesDeleteManifestDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List<KubernetesDeleteManifestDescription> priorDescriptions, KubernetesDeleteManifestDescription description, ValidationErrors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("deleteKubernetesManifest", errors);
        ImmutableList coordinates = description.isDynamic() ? description.getAllCoordinates() : ImmutableList.of((Object)description.getPointCoordinates());
        for (KubernetesCoordinates coordinate : coordinates) {
            if (util.validateCredentials(this.provider, description.getAccount(), coordinate.getKind(), coordinate.getNamespace())) continue;
            return;
        }
    }
}

