/*
 * Copyright 2017 Google, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.model.Application;
import java.util.Map;
import java.util.Set;
import lombok.Value;

@Value
public final class KubernetesApplication implements Application {
  private final String name;
  private final Map<String, Set<String>> clusterNames;

  @Override
  public Map<String, String> getAttributes() {
    return new ImmutableMap.Builder<String, String>().put("name", name).build();
  }
}
