/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.artifact;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.Replacer;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ArtifactReplacer {
    private static final Logger log = LoggerFactory.getLogger(ArtifactReplacer.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    private final ImmutableList<Replacer> replacers;

    public ArtifactReplacer(Collection<Replacer> replacers) {
        this.replacers = ImmutableList.copyOf(replacers);
    }

    private static ImmutableList<Artifact> filterArtifacts(@Nonnull String namespace, @Nonnull String account, List<Artifact> artifacts) {
        return (ImmutableList)artifacts.stream().filter(a -> !Strings.isNullOrEmpty((String)a.getType())).filter(ArtifactReplacer.nonKubernetes().or(ArtifactReplacer.namespaceMatches(namespace).and(ArtifactReplacer.accountMatches(account)))).collect(ImmutableList.toImmutableList());
    }

    private static Predicate<Artifact> nonKubernetes() {
        return a -> !a.getType().startsWith("kubernetes/");
    }

    private static Predicate<Artifact> namespaceMatches(@Nonnull String namespace) {
        return a -> Strings.nullToEmpty((String)a.getLocation()).equals(namespace);
    }

    private static Predicate<Artifact> accountMatches(@Nonnull String account) {
        return a -> {
            String artifactAccount = Strings.nullToEmpty((String)((String)a.getMetadata("account")));
            return artifactAccount.isEmpty() || artifactAccount.equals(account);
        };
    }

    @Nonnull
    public ReplaceResult replaceAll(String dockerImageBinding, KubernetesManifest input, List<Artifact> artifacts, @Nonnull String namespace, @Nonnull String account) {
        DocumentContext document;
        log.debug("Doing replacement on {} using {}", (Object)input, artifacts);
        try {
            document = JsonPath.using((Configuration)configuration).parse(mapper.writeValueAsString((Object)input));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Malformed manifest", (IOException)((Object)e));
        }
        ImmutableList<Artifact> filteredArtifacts = ArtifactReplacer.filterArtifacts(namespace, account, artifacts);
        ImmutableSet.Builder replacedArtifacts = ImmutableSet.builder();
        for (Replacer replacer : this.replacers) {
            ImmutableCollection<Artifact> replaced = replacer.replaceArtifacts(dockerImageBinding, document, (Collection<Artifact>)filteredArtifacts);
            replacedArtifacts.addAll(replaced);
        }
        try {
            return new ReplaceResult((KubernetesManifest)mapper.readValue(document.jsonString(), KubernetesManifest.class), (ImmutableSet<Artifact>)replacedArtifacts.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Malformed manifest", e);
        }
    }

    @Nonnull
    public ImmutableSet<Artifact> findAll(KubernetesManifest input) {
        DocumentContext document;
        try {
            document = JsonPath.using((Configuration)configuration).parse(mapper.writeValueAsString((Object)input));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Malformed manifest", (IOException)((Object)e));
        }
        return (ImmutableSet)this.replacers.stream().flatMap(r -> {
            try {
                return r.getArtifacts(document);
            }
            catch (Exception e) {
                log.debug("Failure converting artifacts for {} using {} (skipping)", new Object[]{input.getFullResourceName(), r, e});
                return Stream.empty();
            }
        }).collect(ImmutableSet.toImmutableSet());
    }

    public static final class ReplaceResult {
        private final KubernetesManifest manifest;
        private final ImmutableSet<Artifact> boundArtifacts;

        @Generated
        public ReplaceResult(KubernetesManifest manifest, ImmutableSet<Artifact> boundArtifacts) {
            this.manifest = manifest;
            this.boundArtifacts = boundArtifacts;
        }

        @Generated
        public KubernetesManifest getManifest() {
            return this.manifest;
        }

        @Generated
        public ImmutableSet<Artifact> getBoundArtifacts() {
            return this.boundArtifacts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceResult)) {
                return false;
            }
            ReplaceResult other = (ReplaceResult)o;
            KubernetesManifest this$manifest = this.getManifest();
            KubernetesManifest other$manifest = other.getManifest();
            if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
                return false;
            }
            ImmutableSet<Artifact> this$boundArtifacts = this.getBoundArtifacts();
            ImmutableSet<Artifact> other$boundArtifacts = other.getBoundArtifacts();
            return !(this$boundArtifacts == null ? other$boundArtifacts != null : !this$boundArtifacts.equals(other$boundArtifacts));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KubernetesManifest $manifest = this.getManifest();
            result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
            ImmutableSet<Artifact> $boundArtifacts = this.getBoundArtifacts();
            result = result * 59 + ($boundArtifacts == null ? 43 : $boundArtifacts.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ArtifactReplacer.ReplaceResult(manifest=" + String.valueOf(this.getManifest()) + ", boundArtifacts=" + String.valueOf(this.getBoundArtifacts()) + ")";
        }
    }
}

