/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.Front50ApplicationLoader;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesConfigurationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import org.springframework.lang.Nullable;

public class CustomKubernetesCachingAgentFactory {
    public static KubernetesCachingAgent create(KubernetesKind kind, KubernetesNamedAccountCredentials namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval, KubernetesConfigurationProperties configurationProperties, KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap, @Nullable Front50ApplicationLoader front50ApplicationLoader) {
        return new Agent(kind, namedAccountCredentials, objectMapper, registry, agentIndex, agentCount, agentInterval, configurationProperties, kubernetesSpinnakerKindMap, front50ApplicationLoader);
    }

    private static class Agent
    extends KubernetesCachingAgent {
        private final KubernetesKind kind;

        Agent(KubernetesKind kind, KubernetesNamedAccountCredentials namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval, KubernetesConfigurationProperties configurationProperties, KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap, @Nullable Front50ApplicationLoader front50ApplicationLoader) {
            super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount, agentInterval, configurationProperties, kubernetesSpinnakerKindMap, front50ApplicationLoader);
            this.kind = kind;
        }

        protected ImmutableList<KubernetesKind> primaryKinds() {
            return ImmutableList.of((Object)this.kind);
        }

        public final ImmutableSet<AgentDataType> getProvidedDataTypes() {
            return ImmutableSet.of((Object)AgentDataType.Authority.AUTHORITATIVE.forType(this.kind.toString()));
        }

        @Override
        public String getAgentType() {
            return String.format("%s/CustomKubernetes(%s)[%d/%d]", this.accountName, this.kind, this.agentIndex + 1, this.agentCount);
        }
    }
}

