/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.model.Front50Application;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kubernetes.cache.checkApplicationInFront50"})
public class Front50ApplicationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Front50ApplicationLoader.class);
    @Nullable
    private final Front50Service front50Service;
    private AtomicReference<Set<String>> cache;

    Front50ApplicationLoader(@Nullable Front50Service front50Service) {
        this.front50Service = front50Service;
        this.cache = new AtomicReference(Collections.emptySet());
    }

    public Set<String> getData() {
        return this.cache.get();
    }

    @Scheduled(fixedDelayString="${kubernetes.cache.refreshFront50ApplicationsCacheIntervalInMs:60000}")
    protected void refreshCache() {
        try {
            log.info("refreshing front50 applications cache");
            if (this.front50Service == null) {
                log.info("front50 is disabled, cannot fetch applications");
                return;
            }
            Set response = (Set)AuthenticatedRequest.allowAnonymous(() -> ((Front50Service)this.front50Service).getAllApplicationsUnrestricted());
            Set applicationsKnownToFront50 = response.stream().map(Front50Application::getName).collect(Collectors.toSet());
            log.info("received {} applications from front50", (Object)applicationsKnownToFront50.size());
            this.cache.set(applicationsKnownToFront50);
        }
        catch (Exception e) {
            log.warn("failed to update application cache with new front50 data. Error: ", (Throwable)e);
        }
    }
}

