/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class KubernetesCacheData {
    private final Map<Keys.CacheKey, CacheItem> items = new HashMap<Keys.CacheKey, CacheItem>();

    public void addItem(Keys.CacheKey key, Map<String, Object> attributes) {
        CacheItem item = this.items.computeIfAbsent(key, CacheItem::new);
        item.getAttributes().putAll(attributes);
    }

    public void addRelationship(Keys.CacheKey a, Keys.CacheKey b) {
        this.items.computeIfAbsent(a, CacheItem::new).getRelationships().add(b);
        this.items.computeIfAbsent(b, CacheItem::new).getRelationships().add(a);
    }

    public void addRelationships(Keys.CacheKey a, Set<Keys.CacheKey> b) {
        this.items.computeIfAbsent(a, CacheItem::new).getRelationships().addAll(b);
        b.forEach(k -> this.items.computeIfAbsent((Keys.CacheKey)k, CacheItem::new).getRelationships().add(a));
    }

    public List<CacheData> toCacheData() {
        return this.items.values().stream().filter(item -> !item.omitItem()).map(CacheItem::toCacheData).collect(Collectors.toList());
    }

    public Map<String, Collection<CacheData>> toStratifiedCacheData() {
        return this.items.values().stream().filter(item -> !item.omitItem()).collect(Collectors.groupingBy(item -> item.key.getGroup(), Collectors.mapping(CacheItem::toCacheData, Collectors.toCollection(ArrayList::new))));
    }

    private static final class CacheItem {
        private final Keys.CacheKey key;
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Set<Keys.CacheKey> relationships = new HashSet<Keys.CacheKey>();

        private Map<String, Collection<String>> groupedRelationships() {
            HashMap<String, Collection<String>> groups = new HashMap<String, Collection<String>>();
            for (KubernetesKind kind : KubernetesCacheDataConverter.getStickyKinds()) {
                groups.put(kind.toString(), new HashSet());
            }
            for (Keys.CacheKey key : this.relationships) {
                groups.computeIfAbsent(key.getGroup(), k -> new HashSet()).add(key.toString());
            }
            return groups;
        }

        public boolean omitItem() {
            return this.key instanceof Keys.InfrastructureCacheKey && this.attributes.isEmpty();
        }

        public CacheData toCacheData() {
            int ttlSeconds;
            if (Keys.LogicalKind.isLogicalGroup(this.key.getGroup())) {
                this.attributes.putIfAbsent("name", this.key.getName());
                ttlSeconds = KubernetesCacheDataConverter.getLogicalTtlSeconds();
            } else {
                ttlSeconds = KubernetesCacheDataConverter.getInfrastructureTtlSeconds();
            }
            return new DefaultCacheData(this.key.toString(), ttlSeconds, this.attributes, this.groupedRelationships());
        }

        @Generated
        public CacheItem(Keys.CacheKey key) {
            this.key = key;
        }

        @Generated
        public Keys.CacheKey getKey() {
            return this.key;
        }

        @Generated
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Generated
        public Set<Keys.CacheKey> getRelationships() {
            return this.relationships;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheItem)) {
                return false;
            }
            CacheItem other = (CacheItem)o;
            Keys.CacheKey this$key = this.getKey();
            Keys.CacheKey other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            Map<String, Object> this$attributes = this.getAttributes();
            Map<String, Object> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            Set<Keys.CacheKey> this$relationships = this.getRelationships();
            Set<Keys.CacheKey> other$relationships = other.getRelationships();
            return !(this$relationships == null ? other$relationships != null : !((Object)this$relationships).equals(other$relationships));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Keys.CacheKey $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            Map<String, Object> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            Set<Keys.CacheKey> $relationships = this.getRelationships();
            result = result * 59 + ($relationships == null ? 43 : ((Object)$relationships).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesCacheData.CacheItem(key=" + String.valueOf(this.getKey()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", relationships=" + String.valueOf(this.getRelationships()) + ")";
        }
    }
}

