/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentIntervalAware;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.Front50ApplicationLoader;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesCachingPolicy;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesConfigurationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesCachingProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKindProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public abstract class KubernetesCachingAgent
implements AgentIntervalAware,
CachingAgent,
AccountAware {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCachingAgent.class);
    public static final List<SpinnakerKind> SPINNAKER_UI_KINDS = Arrays.asList(SpinnakerKind.SERVER_GROUP_MANAGERS, SpinnakerKind.SERVER_GROUPS, SpinnakerKind.INSTANCES, SpinnakerKind.LOAD_BALANCERS, SpinnakerKind.SECURITY_GROUPS);
    @Nonnull
    protected final String accountName;
    protected final Registry registry;
    protected final KubernetesCredentials credentials;
    protected final ObjectMapper objectMapper;
    protected final int agentIndex;
    protected final int agentCount;
    protected KubectlJobExecutor jobExecutor;
    protected String providerName = "kubernetes";
    protected final Long agentInterval;
    protected final KubernetesConfigurationProperties configurationProperties;
    protected final KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap;
    @Nullable
    private final Front50ApplicationLoader front50ApplicationLoader;

    protected KubernetesCachingAgent(KubernetesNamedAccountCredentials namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval, KubernetesConfigurationProperties configurationProperties, KubernetesSpinnakerKindMap kubernetesSpinnakerKindMap, @Nullable Front50ApplicationLoader front50ApplicationLoader) {
        this.accountName = namedAccountCredentials.getName();
        this.credentials = namedAccountCredentials.getCredentials();
        this.objectMapper = objectMapper;
        this.registry = registry;
        this.agentIndex = agentIndex;
        this.agentCount = agentCount;
        this.agentInterval = agentInterval;
        this.configurationProperties = configurationProperties;
        this.kubernetesSpinnakerKindMap = kubernetesSpinnakerKindMap;
        this.front50ApplicationLoader = front50ApplicationLoader;
    }

    protected Map<String, Object> defaultIntrospectionDetails() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("namespaces", this.getNamespaces());
        result.put("kinds", this.filteredPrimaryKinds());
        return result;
    }

    protected abstract List<KubernetesKind> primaryKinds();

    protected List<KubernetesKind> filteredPrimaryKinds() {
        List<KubernetesKind> primaryKinds = this.primaryKinds();
        List<KubernetesKind> filteredPrimaryKinds = this.configurationProperties.getCache().isCacheAll() ? primaryKinds : (this.configurationProperties.getCache().getCacheKinds() != null && this.configurationProperties.getCache().getCacheKinds().size() > 0 ? this.configurationProperties.getCache().getCacheKinds().stream().map(KubernetesKind::fromString).filter(primaryKinds::contains).collect(Collectors.toList()) : SPINNAKER_UI_KINDS.stream().map(this.kubernetesSpinnakerKindMap::translateSpinnakerKind).flatMap(Collection::stream).filter(primaryKinds::contains).collect(Collectors.toList()));
        if (this.configurationProperties.getCache().getCacheOmitKinds() != null && this.configurationProperties.getCache().getCacheOmitKinds().size() > 0) {
            List omitKinds = this.configurationProperties.getCache().getCacheOmitKinds().stream().map(KubernetesKind::fromString).collect(Collectors.toList());
            filteredPrimaryKinds = filteredPrimaryKinds.stream().filter(k -> !omitKinds.contains(k)).collect(Collectors.toList());
        }
        return filteredPrimaryKinds;
    }

    private ImmutableList<KubernetesManifest> loadResources(@Nonnull Iterable<KubernetesKind> kubernetesKinds, Optional<String> optionalNamespace) {
        String namespace = optionalNamespace.orElse(null);
        return this.credentials.list((List<KubernetesKind>)ImmutableList.copyOf(kubernetesKinds), namespace);
    }

    @Nonnull
    private ImmutableList<KubernetesManifest> loadNamespaceScopedResources(@Nonnull Iterable<KubernetesKind> kubernetesKinds) {
        return (ImmutableList)this.getNamespaces().stream().map(n -> this.loadResources(kubernetesKinds, Optional.of(n))).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableList<KubernetesManifest> loadClusterScopedResources(@Nonnull Iterable<KubernetesKind> kubernetesKinds) {
        if (this.handleClusterScopedResources()) {
            return this.loadResources(kubernetesKinds, Optional.empty());
        }
        return ImmutableList.of();
    }

    private ImmutableSetMultimap<KubernetesKindProperties.ResourceScope, KubernetesKind> primaryKindsByScope() {
        return (ImmutableSetMultimap)this.filteredPrimaryKinds().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(k -> this.credentials.getKindProperties((KubernetesKind)k).getResourceScope(), Function.identity()));
    }

    protected Map<KubernetesKind, List<KubernetesManifest>> loadPrimaryResourceList() {
        ImmutableSetMultimap<KubernetesKindProperties.ResourceScope, KubernetesKind> kindsByScope = this.primaryKindsByScope();
        Map<KubernetesKind, List<KubernetesManifest>> result = Stream.concat(this.loadClusterScopedResources((Iterable<KubernetesKind>)kindsByScope.get((Object)KubernetesKindProperties.ResourceScope.CLUSTER)).stream(), this.loadNamespaceScopedResources((Iterable<KubernetesKind>)kindsByScope.get((Object)KubernetesKindProperties.ResourceScope.NAMESPACE)).stream()).collect(Collectors.groupingBy(KubernetesManifest::getKind));
        for (KubernetesCachingPolicy policy : this.credentials.getCachingPolicies()) {
            List<KubernetesManifest> entries;
            KubernetesKind policyKind = KubernetesKind.fromString(policy.getKubernetesKind());
            if (!result.containsKey(policyKind) || (entries = result.get(policyKind)) == null || entries.size() <= policy.getMaxEntriesPerAgent()) continue;
            log.warn("{}: Pruning {} entries from kind {}", new Object[]{this.getAgentType(), entries.size() - policy.getMaxEntriesPerAgent(), policyKind});
            entries = entries.subList(0, policy.getMaxEntriesPerAgent());
            result.put(policyKind, entries);
        }
        return result;
    }

    @Deprecated
    protected KubernetesManifest loadPrimaryResource(KubernetesKind kind, String namespace, String name) {
        return this.loadPrimaryResource(KubernetesCoordinates.builder().kind(kind).namespace(namespace).name(name).build());
    }

    protected KubernetesManifest loadPrimaryResource(KubernetesCoordinates coordinates) {
        return this.credentials.get(coordinates);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        log.info(this.getAgentType() + ": agent is starting");
        Map<String, Object> details = this.defaultIntrospectionDetails();
        long start = System.currentTimeMillis();
        Map<KubernetesKind, List<KubernetesManifest>> primaryResourceList = this.loadPrimaryResourceList();
        details.put("timeSpentInKubectlMs", System.currentTimeMillis() - start);
        return this.buildCacheResult(primaryResourceList);
    }

    protected CacheResult buildCacheResult(KubernetesManifest resource) {
        return this.buildCacheResult((Map<KubernetesKind, List<KubernetesManifest>>)ImmutableMap.of((Object)resource.getKind(), (Object)ImmutableList.of((Object)resource)));
    }

    private Predicate<KubernetesManifest> shouldCacheManifest(KubernetesCredentials credentials) {
        return m -> {
            KubernetesCachingProperties props = KubernetesManifestAnnotater.getCachingProperties(m);
            if (props.isIgnore()) {
                return false;
            }
            if (credentials.isOnlySpinnakerManaged() && props.getApplication().isEmpty()) {
                return false;
            }
            if (this.configurationProperties.getCache().isCheckApplicationInFront50()) {
                SpinnakerKind spinnakerKind = credentials.getKubernetesSpinnakerKindMap().translateKubernetesKind(m.getKind());
                log.debug("{}: manifest: {}, kind: {}, spinnakerKind: {}, logicalRelationshipKinds: {}", new Object[]{this.getAgentType(), m.getFullResourceName(), m.getKind(), spinnakerKind, KubernetesCacheDataConverter.getLogicalRelationshipKinds()});
                if (KubernetesCacheDataConverter.getLogicalRelationshipKinds().contains((Object)spinnakerKind)) {
                    if (this.front50ApplicationLoader == null) {
                        return false;
                    }
                    String appNameFromMoniker = credentials.getNamer().deriveMoniker(m).getApp();
                    boolean shouldCache = this.front50ApplicationLoader.getData().stream().anyMatch(app -> app.equalsIgnoreCase(appNameFromMoniker));
                    log.debug("{}: manifest: {}, application name: {}, shouldCache: {}", new Object[]{this.getAgentType(), m.getFullResourceName(), appNameFromMoniker, shouldCache});
                    return shouldCache;
                }
            }
            return true;
        };
    }

    protected CacheResult buildCacheResult(Map<KubernetesKind, List<KubernetesManifest>> resources) {
        if (resources.isEmpty()) {
            log.info("{} did not find anything to cache", (Object)this.getAgentType());
            return new DefaultCacheResult(Map.of());
        }
        KubernetesCacheData kubernetesCacheData = new KubernetesCacheData();
        Map<KubernetesManifest, List<KubernetesManifest>> relationships = this.loadSecondaryResourceRelationships(resources);
        AtomicInteger successfulCachedManifests = new AtomicInteger();
        AtomicInteger cachingFailures = new AtomicInteger();
        resources.values().stream().flatMap(Collection::stream).peek(m -> this.credentials.getResourcePropertyRegistry().get(m.getKind()).getHandler().removeSensitiveKeys((KubernetesManifest)m)).filter(this.shouldCacheManifest(this.credentials)).forEach(rs -> {
            try {
                KubernetesCacheDataConverter.convertAsResource(kubernetesCacheData, this.accountName, this.credentials.getKubernetesSpinnakerKindMap(), this.credentials.getNamer(), rs, (List)relationships.getOrDefault(rs, (List<KubernetesManifest>)ImmutableList.of()), this.credentials.isCacheAllApplicationRelationships());
                successfulCachedManifests.incrementAndGet();
            }
            catch (RuntimeException e) {
                log.warn("{}: Failure converting manifest: {}. Error: ", new Object[]{this.getAgentType(), rs.getFullResourceName(), e});
                log.debug("{}: Failure converting {}. Error: ", new Object[]{this.getAgentType(), rs, e});
                cachingFailures.incrementAndGet();
            }
        });
        Map<String, Collection<CacheData>> entries = kubernetesCacheData.toStratifiedCacheData();
        int total = resources.values().stream().mapToInt(List::size).sum();
        int cachedEntriesTotal = entries.values().stream().mapToInt(Collection::size).sum();
        log.info("{}: Results: Attempted to cache {} manifests, belonging to {} kinds. Successful: {}, Failed: {}, Skipped: {}, Total Kubernetes caching groups: {}, containing: {} entries", new Object[]{this.getAgentType(), total, resources.size(), successfulCachedManifests.get(), cachingFailures.get(), total - (successfulCachedManifests.get() + cachingFailures.get()), entries.size(), cachedEntriesTotal});
        KubernetesCacheDataConverter.logStratifiedCacheData(this.getAgentType(), entries);
        return new DefaultCacheResult(entries);
    }

    protected Map<KubernetesManifest, List<KubernetesManifest>> loadSecondaryResourceRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources) {
        HashMap<KubernetesManifest, List<KubernetesManifest>> result = new HashMap<KubernetesManifest, List<KubernetesManifest>>();
        allResources.keySet().forEach(k -> {
            try {
                this.credentials.getResourcePropertyRegistry().get((KubernetesKind)k).getHandler().addRelationships(allResources, result);
            }
            catch (RuntimeException e) {
                log.warn("{}: Failure adding relationships for {}", new Object[]{this.getAgentType(), k, e});
            }
        });
        return result;
    }

    protected ImmutableList<String> getNamespaces() {
        return (ImmutableList)this.credentials.getDeclaredNamespaces().stream().filter(n -> this.agentCount == 1 || Math.abs(n.hashCode() % this.agentCount) == this.agentIndex).collect(ImmutableList.toImmutableList());
    }

    protected boolean handleClusterScopedResources() {
        return this.agentIndex == 0;
    }

    public String getAgentType() {
        return String.format("%s/%s[%d/%d]", this.accountName, this.getClass().getSimpleName(), this.agentIndex + 1, this.agentCount);
    }

    @Nonnull
    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @Generated
    public Long getAgentInterval() {
        return this.agentInterval;
    }
}

