/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesLoadBalancer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesServerGroup;
import com.netflix.spinnaker.clouddriver.model.Cluster;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public final class KubernetesCluster
implements Cluster {
    private final String name;
    private final Moniker moniker;
    private final String type = "kubernetes";
    private final String accountName;
    private final Set<KubernetesServerGroup> serverGroups;
    private final Set<KubernetesLoadBalancer> loadBalancers;
    private final String application;

    public KubernetesCluster(String rawKey) {
        this(rawKey, (Collection<KubernetesServerGroup>)ImmutableList.of(), (Collection<KubernetesLoadBalancer>)ImmutableList.of());
    }

    public KubernetesCluster(String rawKey, Collection<KubernetesServerGroup> serverGroups, Collection<KubernetesLoadBalancer> loadBalancers) {
        Keys.ClusterCacheKey key = (Keys.ClusterCacheKey)Keys.parseKey(rawKey).get();
        this.name = key.getName();
        this.accountName = key.getAccount();
        this.application = key.getApplication();
        this.moniker = Moniker.builder().cluster(this.name).app(this.application).build();
        this.serverGroups = new HashSet<KubernetesServerGroup>(serverGroups);
        this.loadBalancers = new HashSet<KubernetesLoadBalancer>(loadBalancers);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Moniker getMoniker() {
        return this.moniker;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public Set<KubernetesServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    @Generated
    public Set<KubernetesLoadBalancer> getLoadBalancers() {
        return this.loadBalancers;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesCluster)) {
            return false;
        }
        KubernetesCluster other = (KubernetesCluster)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Moniker this$moniker = this.getMoniker();
        Moniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !this$moniker.equals(other$moniker)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        Set<KubernetesServerGroup> this$serverGroups = this.getServerGroups();
        Set<KubernetesServerGroup> other$serverGroups = other.getServerGroups();
        if (this$serverGroups == null ? other$serverGroups != null : !((Object)this$serverGroups).equals(other$serverGroups)) {
            return false;
        }
        Set<KubernetesLoadBalancer> this$loadBalancers = this.getLoadBalancers();
        Set<KubernetesLoadBalancer> other$loadBalancers = other.getLoadBalancers();
        if (this$loadBalancers == null ? other$loadBalancers != null : !((Object)this$loadBalancers).equals(other$loadBalancers)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        return !(this$application == null ? other$application != null : !this$application.equals(other$application));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Moniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : $moniker.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        Set<KubernetesServerGroup> $serverGroups = this.getServerGroups();
        result = result * 59 + ($serverGroups == null ? 43 : ((Object)$serverGroups).hashCode());
        Set<KubernetesLoadBalancer> $loadBalancers = this.getLoadBalancers();
        result = result * 59 + ($loadBalancers == null ? 43 : ((Object)$loadBalancers).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesCluster(name=" + this.getName() + ", moniker=" + String.valueOf(this.getMoniker()) + ", type=" + this.getType() + ", accountName=" + this.getAccountName() + ", serverGroups=" + String.valueOf(this.getServerGroups()) + ", loadBalancers=" + String.valueOf(this.getLoadBalancers()) + ", application=" + this.getApplication() + ")";
    }
}

