/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesCluster;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesLoadBalancer;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.model.KubernetesServerGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.view.provider.data.KubernetesServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.description.SpinnakerKind;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesClusterProvider
implements ClusterProvider<KubernetesCluster> {
    private final KubernetesCacheUtils cacheUtils;
    private final ServerGroupHandler DEFAULT_SERVER_GROUP_HANDLER = new ServerGroupHandler(){};

    @Autowired
    KubernetesClusterProvider(KubernetesCacheUtils cacheUtils) {
        this.cacheUtils = cacheUtils;
    }

    public Map<String, Set<KubernetesCluster>> getClusters() {
        return this.groupByAccountName(this.loadClusters(this.cacheUtils.getAllKeys(Keys.LogicalKind.CLUSTERS.toString())));
    }

    public Map<String, Set<KubernetesCluster>> getClusterSummaries(String application) {
        String applicationKey = Keys.ApplicationCacheKey.createKey(application);
        return this.groupByAccountName(this.loadClusterSummaries(this.cacheUtils.getSingleEntryWithRelationships(Keys.LogicalKind.APPLICATIONS.toString(), applicationKey, RelationshipCacheFilter.include((String[])new String[]{Keys.LogicalKind.CLUSTERS.toString()})).map(d -> this.cacheUtils.getRelationships((CacheData)d, Keys.LogicalKind.CLUSTERS.toString())).orElseGet(ImmutableList::of)));
    }

    public Map<String, Set<KubernetesCluster>> getClusterDetails(String application) {
        String clusterGlobKey = Keys.ClusterCacheKey.createKey("*", application, "*");
        return this.groupByAccountName(this.loadClusters(this.cacheUtils.getAllDataMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), clusterGlobKey)));
    }

    public Set<KubernetesCluster> getClusters(String application, String account) {
        String globKey = Keys.ClusterCacheKey.createKey(account, application, "*");
        return this.loadClusters(this.cacheUtils.getAllDataMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), globKey));
    }

    public KubernetesCluster getCluster(String application, String account, String name) {
        return this.getCluster(application, account, name, true);
    }

    public KubernetesCluster getCluster(String application, String account, String name, boolean includeDetails) {
        return this.cacheUtils.getSingleEntry(Keys.LogicalKind.CLUSTERS.toString(), Keys.ClusterCacheKey.createKey(account, application, name)).map(entry -> {
            ImmutableList clusterData = ImmutableList.of((Object)entry);
            Set<KubernetesCluster> result = includeDetails ? this.loadClusters((Collection<CacheData>)clusterData) : this.loadClusterSummaries((Collection<CacheData>)clusterData);
            return result.iterator().next();
        }).orElse(null);
    }

    @Nullable
    public KubernetesServerGroup getServerGroup(String account, String namespace, String fullName, boolean includeDetails) {
        return this.cacheUtils.getSingleEntry(account, namespace, fullName).map(serverGroupData -> (KubernetesServerGroup)this.loadServerGroups((ImmutableCollection<CacheData>)ImmutableList.of((Object)serverGroupData)).get((Object)serverGroupData.getId())).orElse(null);
    }

    public KubernetesServerGroup getServerGroup(String account, String namespace, String name) {
        return this.getServerGroup(account, namespace, name, true);
    }

    public String getCloudProviderId() {
        return "kubernetes";
    }

    public boolean supportsMinimalClusters() {
        return true;
    }

    private Map<String, Set<KubernetesCluster>> groupByAccountName(Collection<KubernetesCluster> clusters) {
        return clusters.stream().collect(Collectors.groupingBy(KubernetesCluster::getAccountName, Collectors.toSet()));
    }

    private Set<KubernetesCluster> loadClusterSummaries(Collection<CacheData> clusterData) {
        return clusterData.stream().map(clusterDatum -> new KubernetesCluster(clusterDatum.getId())).collect(Collectors.toSet());
    }

    private Set<KubernetesCluster> loadClusters(Collection<CacheData> clusterData) {
        ImmutableMultimap<String, CacheData> clusterToServerGroups = this.cacheUtils.getRelationships(clusterData, SpinnakerKind.SERVER_GROUPS);
        return clusterData.stream().map(clusterDatum -> {
            ImmutableCollection clusterServerGroups = clusterToServerGroups.get((Object)clusterDatum.getId());
            ImmutableMap<String, KubernetesServerGroup> serverGroups = this.loadServerGroups((ImmutableCollection<CacheData>)clusterServerGroups);
            List<KubernetesLoadBalancer> loadBalancers = this.cacheUtils.getRelationships((Collection<CacheData>)clusterServerGroups, SpinnakerKind.LOAD_BALANCERS).values().stream().filter(this.cacheUtils.distinctById()).map(cd -> KubernetesLoadBalancer.fromCacheData(cd, (Set)this.cacheUtils.getRelationshipKeys((CacheData)cd, SpinnakerKind.SERVER_GROUPS).stream().map(arg_0 -> ((ImmutableMap)serverGroups).get(arg_0)).filter(Objects::nonNull).map(KubernetesServerGroup::toLoadBalancerServerGroup).collect(ImmutableSet.toImmutableSet()))).filter(Objects::nonNull).collect(Collectors.toList());
            return new KubernetesCluster(clusterDatum.getId(), (Collection<KubernetesServerGroup>)serverGroups.values(), loadBalancers);
        }).collect(Collectors.toSet());
    }

    private ImmutableMap<String, KubernetesServerGroup> loadServerGroups(ImmutableCollection<CacheData> serverGroupData) {
        ImmutableMultimap<String, CacheData> serverGroupToInstances = this.cacheUtils.getRelationships((Collection<CacheData>)serverGroupData, SpinnakerKind.INSTANCES);
        return (ImmutableMap)serverGroupData.stream().collect(ImmutableMap.toImmutableMap(CacheData::getId, cd -> this.serverGroupFromCacheData(KubernetesServerGroupCacheData.builder().serverGroupData((CacheData)cd).instanceData((Collection<CacheData>)serverGroupToInstances.get((Object)cd.getId())).loadBalancerKeys((Collection<String>)this.cacheUtils.getRelationshipKeys((CacheData)cd, SpinnakerKind.LOAD_BALANCERS)).serverGroupManagerKeys((Collection<String>)this.cacheUtils.getRelationshipKeys((CacheData)cd, SpinnakerKind.SERVER_GROUP_MANAGERS)).build()), (sg1, sg2) -> sg1));
    }

    @Nonnull
    private KubernetesServerGroup serverGroupFromCacheData(@Nonnull KubernetesServerGroupCacheData cacheData) {
        KubernetesHandler handler = this.cacheUtils.getHandler(cacheData);
        ServerGroupHandler serverGroupHandler = handler instanceof ServerGroupHandler ? (ServerGroupHandler)((Object)handler) : this.DEFAULT_SERVER_GROUP_HANDLER;
        return serverGroupHandler.fromCacheData(cacheData);
    }
}

