/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;

public class RawResourcesEndpointConfig {
    private Set<String> kindExpressions = new HashSet<String>();
    private Set<String> omitKindExpressions = new HashSet<String>();
    private List<Pattern> kindPatterns = new ArrayList<Pattern>();
    private List<Pattern> omitKindPatterns = new ArrayList<Pattern>();

    public void validate() {
        if (!this.kindExpressions.isEmpty() && !this.omitKindExpressions.isEmpty()) {
            throw new IllegalArgumentException("At most one of 'kindExpressions' and 'omitKindExpressions' can be specified");
        }
        for (String exp : this.kindExpressions) {
            this.kindPatterns.add(Pattern.compile(exp));
        }
        for (String exp : this.omitKindExpressions) {
            this.omitKindPatterns.add(Pattern.compile(exp));
        }
    }

    @Generated
    public RawResourcesEndpointConfig() {
    }

    @Generated
    public Set<String> getKindExpressions() {
        return this.kindExpressions;
    }

    @Generated
    public Set<String> getOmitKindExpressions() {
        return this.omitKindExpressions;
    }

    @Generated
    public RawResourcesEndpointConfig setKindExpressions(Set<String> kindExpressions) {
        this.kindExpressions = kindExpressions;
        return this;
    }

    @Generated
    public RawResourcesEndpointConfig setOmitKindExpressions(Set<String> omitKindExpressions) {
        this.omitKindExpressions = omitKindExpressions;
        return this;
    }

    @Generated
    public RawResourcesEndpointConfig setKindPatterns(List<Pattern> kindPatterns) {
        this.kindPatterns = kindPatterns;
        return this;
    }

    @Generated
    public RawResourcesEndpointConfig setOmitKindPatterns(List<Pattern> omitKindPatterns) {
        this.omitKindPatterns = omitKindPatterns;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawResourcesEndpointConfig)) {
            return false;
        }
        RawResourcesEndpointConfig other = (RawResourcesEndpointConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$kindExpressions = this.getKindExpressions();
        Set<String> other$kindExpressions = other.getKindExpressions();
        if (this$kindExpressions == null ? other$kindExpressions != null : !((Object)this$kindExpressions).equals(other$kindExpressions)) {
            return false;
        }
        Set<String> this$omitKindExpressions = this.getOmitKindExpressions();
        Set<String> other$omitKindExpressions = other.getOmitKindExpressions();
        if (this$omitKindExpressions == null ? other$omitKindExpressions != null : !((Object)this$omitKindExpressions).equals(other$omitKindExpressions)) {
            return false;
        }
        List<Pattern> this$kindPatterns = this.getKindPatterns();
        List<Pattern> other$kindPatterns = other.getKindPatterns();
        if (this$kindPatterns == null ? other$kindPatterns != null : !((Object)this$kindPatterns).equals(other$kindPatterns)) {
            return false;
        }
        List<Pattern> this$omitKindPatterns = this.getOmitKindPatterns();
        List<Pattern> other$omitKindPatterns = other.getOmitKindPatterns();
        return !(this$omitKindPatterns == null ? other$omitKindPatterns != null : !((Object)this$omitKindPatterns).equals(other$omitKindPatterns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawResourcesEndpointConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $kindExpressions = this.getKindExpressions();
        result = result * 59 + ($kindExpressions == null ? 43 : ((Object)$kindExpressions).hashCode());
        Set<String> $omitKindExpressions = this.getOmitKindExpressions();
        result = result * 59 + ($omitKindExpressions == null ? 43 : ((Object)$omitKindExpressions).hashCode());
        List<Pattern> $kindPatterns = this.getKindPatterns();
        result = result * 59 + ($kindPatterns == null ? 43 : ((Object)$kindPatterns).hashCode());
        List<Pattern> $omitKindPatterns = this.getOmitKindPatterns();
        result = result * 59 + ($omitKindPatterns == null ? 43 : ((Object)$omitKindPatterns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RawResourcesEndpointConfig(kindExpressions=" + String.valueOf(this.getKindExpressions()) + ", omitKindExpressions=" + String.valueOf(this.getOmitKindExpressions()) + ", kindPatterns=" + String.valueOf(this.getKindPatterns()) + ", omitKindPatterns=" + String.valueOf(this.getOmitKindPatterns()) + ")";
    }

    @Generated
    public List<Pattern> getKindPatterns() {
        return this.kindPatterns;
    }

    @Generated
    public List<Pattern> getOmitKindPatterns() {
        return this.omitKindPatterns;
    }
}

