/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.description.manifest;

import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import java.util.OptionalInt;

public class KubernetesSourceCapacity {
    public static Integer getSourceCapacity(KubernetesManifest manifest, KubernetesCredentials credentials, OptionalInt currentVersion) {
        String name = KubernetesSourceCapacity.currentManifestName(manifest, currentVersion);
        KubernetesManifest currentManifest = credentials.get(KubernetesCoordinates.builder().kind(manifest.getKind()).namespace(manifest.getNamespace()).name(name).build());
        if (currentManifest != null) {
            return currentManifest.getReplicas();
        }
        return null;
    }

    private static String currentManifestName(KubernetesManifest manifest, OptionalInt currentVersion) {
        if (currentVersion.isEmpty()) {
            return manifest.getName();
        }
        int version = currentVersion.getAsInt();
        String versionString = String.format("v%03d", version);
        return String.join((CharSequence)"-", manifest.getName(), versionString);
    }
}

