/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.model;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;

public interface Manifest {
    public Moniker getMoniker();

    public String getAccount();

    public String getName();

    public String getLocation();

    public Status getStatus();

    public List<Warning> getWarnings();

    public static class Warning {
        private String type;
        private String message;

        @Generated
        Warning(String type, String message) {
            this.type = type;
            this.message = message;
        }

        @Generated
        public static WarningBuilder builder() {
            return new WarningBuilder();
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public Warning setType(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public Warning setMessage(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Warning)) {
                return false;
            }
            Warning other = (Warning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Warning;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Manifest.Warning(type=" + this.getType() + ", message=" + this.getMessage() + ")";
        }

        @Generated
        public static class WarningBuilder {
            @Generated
            private String type;
            @Generated
            private String message;

            @Generated
            WarningBuilder() {
            }

            @Generated
            public WarningBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public WarningBuilder message(String message) {
                this.message = message;
                return this;
            }

            @Generated
            public Warning build() {
                return new Warning(this.type, this.message);
            }

            @Generated
            public String toString() {
                return "Manifest.Warning.WarningBuilder(type=" + this.type + ", message=" + this.message + ")";
            }
        }
    }

    @NonnullByDefault
    public static class Status {
        private Condition stable = Condition.withState(true);
        private Condition paused = Condition.withState(false);
        private Condition available = Condition.withState(true);
        private Condition failed = Condition.withState(false);

        public static Status defaultStatus() {
            return new Status();
        }

        public static Status noneReported() {
            return Status.defaultStatus().unstable("No status reported yet").unavailable("No availability reported");
        }

        public Status failed(@Nullable String message) {
            this.failed = new Condition(true, message);
            return this;
        }

        public Status stable(@Nullable String message) {
            this.stable = new Condition(true, message);
            return this;
        }

        public Status unstable(@Nullable String message) {
            this.stable = new Condition(false, message);
            return this;
        }

        public Status paused(@Nullable String message) {
            this.paused = new Condition(true, message);
            return this;
        }

        public Status unavailable(@Nullable String message) {
            this.available = new Condition(false, message);
            return this;
        }

        @Generated
        public Condition getStable() {
            return this.stable;
        }

        @Generated
        public Condition getPaused() {
            return this.paused;
        }

        @Generated
        public Condition getAvailable() {
            return this.available;
        }

        @Generated
        public Condition getFailed() {
            return this.failed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Condition this$stable = this.getStable();
            Condition other$stable = other.getStable();
            if (this$stable == null ? other$stable != null : !((Object)this$stable).equals(other$stable)) {
                return false;
            }
            Condition this$paused = this.getPaused();
            Condition other$paused = other.getPaused();
            if (this$paused == null ? other$paused != null : !((Object)this$paused).equals(other$paused)) {
                return false;
            }
            Condition this$available = this.getAvailable();
            Condition other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            Condition this$failed = this.getFailed();
            Condition other$failed = other.getFailed();
            return !(this$failed == null ? other$failed != null : !((Object)this$failed).equals(other$failed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Status;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Condition $stable = this.getStable();
            result = result * 59 + ($stable == null ? 43 : ((Object)$stable).hashCode());
            Condition $paused = this.getPaused();
            result = result * 59 + ($paused == null ? 43 : ((Object)$paused).hashCode());
            Condition $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            Condition $failed = this.getFailed();
            result = result * 59 + ($failed == null ? 43 : ((Object)$failed).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Manifest.Status(stable=" + String.valueOf(this.getStable()) + ", paused=" + String.valueOf(this.getPaused()) + ", available=" + String.valueOf(this.getAvailable()) + ", failed=" + String.valueOf(this.getFailed()) + ")";
        }

        @NonnullByDefault
        public static final class Condition {
            private static final Condition TRUE = new Condition(true, null);
            private static final Condition FALSE = new Condition(false, null);
            private final boolean state;
            @Nullable
            private final String message;

            private static Condition withState(boolean state) {
                return state ? TRUE : FALSE;
            }

            private Condition(boolean state, @Nullable String message) {
                this.state = state;
                this.message = message;
            }

            @Generated
            public boolean isState() {
                return this.state;
            }

            @Nullable
            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Condition)) {
                    return false;
                }
                Condition other = (Condition)o;
                if (this.isState() != other.isState()) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isState() ? 79 : 97);
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Manifest.Status.Condition(state=" + this.isState() + ", message=" + this.getMessage() + ")";
            }
        }
    }
}

