/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.names;

import com.netflix.frigga.Names;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class KubernetesResourceAwareNames {
    private static final String KUBERNETES_SYSTEM_RESOURCE_PREFIX = "system:";
    private static final Pattern PUSH_PATTERN = Pattern.compile("^([system:].*)-(v([0-9]{3,6}))$");
    private final String cluster;
    private final String app;
    private final Integer sequence;

    public KubernetesResourceAwareNames(String cluster, String application, Integer sequence) {
        this.cluster = cluster;
        this.app = application;
        this.sequence = sequence;
    }

    public static KubernetesResourceAwareNames parseName(String manifestName) {
        if (manifestName != null && !manifestName.trim().isEmpty() && manifestName.startsWith(KUBERNETES_SYSTEM_RESOURCE_PREFIX)) {
            return KubernetesResourceAwareNames.parseSystemResourceName(manifestName);
        }
        Names parsed = Names.parseName((String)manifestName);
        return new KubernetesResourceAwareNames(parsed.getCluster(), parsed.getApp(), parsed.getSequence());
    }

    private static KubernetesResourceAwareNames parseSystemResourceName(String manifestName) {
        String sequenceString;
        String[] split = manifestName.split(":");
        Integer sequence = null;
        Matcher pushMatcher = PUSH_PATTERN.matcher(manifestName);
        boolean hasPush = pushMatcher.matches();
        String theCluster = hasPush ? pushMatcher.group(1) : manifestName;
        String string = sequenceString = hasPush ? pushMatcher.group(3) : null;
        if (sequenceString != null) {
            sequence = Integer.parseInt(sequenceString);
        }
        return new KubernetesResourceAwareNames(theCluster, split[0], sequence);
    }

    @Generated
    public String getCluster() {
        return this.cluster;
    }

    @Generated
    public String getApp() {
        return this.app;
    }

    @Generated
    public Integer getSequence() {
        return this.sequence;
    }
}

