/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op;

import com.netflix.spinnaker.clouddriver.kubernetes.description.ResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class OperationResult {
    private Map<String, Set<String>> manifestNamesByNamespace = new HashMap<String, Set<String>>();
    private Set<KubernetesManifest> manifests = new HashSet<KubernetesManifest>();
    private Set<Artifact> createdArtifacts = new HashSet<Artifact>();
    private Set<Artifact> boundArtifacts = new HashSet<Artifact>();

    public void removeSensitiveKeys(ResourcePropertyRegistry propertyRegistry) {
        this.manifests.forEach(m -> propertyRegistry.get(m.getKind()).getHandler().removeSensitiveKeys((KubernetesManifest)m));
    }

    public OperationResult addManifest(KubernetesManifest manifest) {
        this.manifests.add(manifest);
        Set addedNames = this.manifestNamesByNamespace.getOrDefault(manifest.getNamespace(), new HashSet());
        addedNames.add(manifest.getFullResourceName());
        this.manifestNamesByNamespace.put(manifest.getNamespace(), addedNames);
        return this;
    }

    public void merge(OperationResult other) {
        for (Map.Entry<String, Set<String>> entry : other.manifestNamesByNamespace.entrySet()) {
            Set thisManifests = this.manifestNamesByNamespace.getOrDefault(entry.getKey(), new HashSet());
            thisManifests.addAll((Collection)entry.getValue());
            this.manifestNamesByNamespace.put(entry.getKey(), thisManifests);
        }
        this.manifests.addAll(other.manifests);
        this.createdArtifacts.addAll(other.createdArtifacts);
        this.boundArtifacts.addAll(other.boundArtifacts);
    }

    @Generated
    public Map<String, Set<String>> getManifestNamesByNamespace() {
        return this.manifestNamesByNamespace;
    }

    @Generated
    public Set<KubernetesManifest> getManifests() {
        return this.manifests;
    }

    @Generated
    public Set<Artifact> getCreatedArtifacts() {
        return this.createdArtifacts;
    }

    @Generated
    public Set<Artifact> getBoundArtifacts() {
        return this.boundArtifacts;
    }

    @Generated
    public OperationResult setManifestNamesByNamespace(Map<String, Set<String>> manifestNamesByNamespace) {
        this.manifestNamesByNamespace = manifestNamesByNamespace;
        return this;
    }

    @Generated
    public OperationResult setManifests(Set<KubernetesManifest> manifests) {
        this.manifests = manifests;
        return this;
    }

    @Generated
    public OperationResult setCreatedArtifacts(Set<Artifact> createdArtifacts) {
        this.createdArtifacts = createdArtifacts;
        return this;
    }

    @Generated
    public OperationResult setBoundArtifacts(Set<Artifact> boundArtifacts) {
        this.boundArtifacts = boundArtifacts;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationResult)) {
            return false;
        }
        OperationResult other = (OperationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Set<String>> this$manifestNamesByNamespace = this.getManifestNamesByNamespace();
        Map<String, Set<String>> other$manifestNamesByNamespace = other.getManifestNamesByNamespace();
        if (this$manifestNamesByNamespace == null ? other$manifestNamesByNamespace != null : !((Object)this$manifestNamesByNamespace).equals(other$manifestNamesByNamespace)) {
            return false;
        }
        Set<KubernetesManifest> this$manifests = this.getManifests();
        Set<KubernetesManifest> other$manifests = other.getManifests();
        if (this$manifests == null ? other$manifests != null : !((Object)this$manifests).equals(other$manifests)) {
            return false;
        }
        Set<Artifact> this$createdArtifacts = this.getCreatedArtifacts();
        Set<Artifact> other$createdArtifacts = other.getCreatedArtifacts();
        if (this$createdArtifacts == null ? other$createdArtifacts != null : !((Object)this$createdArtifacts).equals(other$createdArtifacts)) {
            return false;
        }
        Set<Artifact> this$boundArtifacts = this.getBoundArtifacts();
        Set<Artifact> other$boundArtifacts = other.getBoundArtifacts();
        return !(this$boundArtifacts == null ? other$boundArtifacts != null : !((Object)this$boundArtifacts).equals(other$boundArtifacts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Set<String>> $manifestNamesByNamespace = this.getManifestNamesByNamespace();
        result = result * 59 + ($manifestNamesByNamespace == null ? 43 : ((Object)$manifestNamesByNamespace).hashCode());
        Set<KubernetesManifest> $manifests = this.getManifests();
        result = result * 59 + ($manifests == null ? 43 : ((Object)$manifests).hashCode());
        Set<Artifact> $createdArtifacts = this.getCreatedArtifacts();
        result = result * 59 + ($createdArtifacts == null ? 43 : ((Object)$createdArtifacts).hashCode());
        Set<Artifact> $boundArtifacts = this.getBoundArtifacts();
        result = result * 59 + ($boundArtifacts == null ? 43 : ((Object)$boundArtifacts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OperationResult(manifestNamesByNamespace=" + String.valueOf(this.getManifestNamesByNamespace()) + ", manifests=" + String.valueOf(this.getManifests()) + ", createdArtifacts=" + String.valueOf(this.getCreatedArtifacts()) + ", boundArtifacts=" + String.valueOf(this.getBoundArtifacts()) + ")";
    }

    @Generated
    public OperationResult() {
    }
}

