/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesSelectorList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import java.util.ArrayList;

public interface CanDeploy {
    default public OperationResult deploy(KubernetesCredentials credentials, KubernetesManifest manifest, KubernetesManifestStrategy.DeployStrategy deployStrategy, KubernetesManifestStrategy.ServerSideApplyStrategy serverSideApplyStrategy, Task task, String opName, KubernetesSelectorList labelSelectors) {
        if (manifest.hasGenerateName()) {
            KubernetesManifest result = credentials.create(manifest, task, opName, labelSelectors);
            OperationResult operationResult = new OperationResult();
            if (result != null) {
                operationResult.addManifest(result);
            }
            return operationResult;
        }
        KubernetesManifest deployedManifest = switch (deployStrategy) {
            case KubernetesManifestStrategy.DeployStrategy.RECREATE -> {
                try {
                    credentials.delete(manifest.getKind(), manifest.getNamespace(), manifest.getName(), labelSelectors, new V1DeleteOptions(), task, opName);
                }
                catch (KubectlJobExecutor.KubectlException operationResult) {
                    // empty catch block
                }
                yield credentials.deploy(manifest, task, opName, labelSelectors, new String[0]);
            }
            case KubernetesManifestStrategy.DeployStrategy.REPLACE -> credentials.createOrReplace(manifest, task, opName);
            case KubernetesManifestStrategy.DeployStrategy.SERVER_SIDE_APPLY -> {
                ArrayList<String> cmdArgs = new ArrayList<String>();
                cmdArgs.add("--server-side=true");
                if (serverSideApplyStrategy.equals((Object)KubernetesManifestStrategy.ServerSideApplyStrategy.FORCE_CONFLICTS)) {
                    cmdArgs.add("--force-conflicts=true");
                }
                yield credentials.deploy(manifest, task, opName, labelSelectors, cmdArgs.toArray(new String[cmdArgs.size()]));
            }
            case KubernetesManifestStrategy.DeployStrategy.APPLY -> credentials.deploy(manifest, task, opName, labelSelectors, new String[0]);
            default -> throw new AssertionError((Object)String.format("Unknown deploy strategy: %s", new Object[]{deployStrategy}));
        };
        OperationResult operationResult = new OperationResult();
        if (deployedManifest != null) {
            operationResult.addManifest(deployedManifest);
        }
        return operationResult;
    }
}

