/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.handler;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.kubernetes.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import java.util.HashMap;
import java.util.List;

public interface CanPatch {
    public KubernetesKind kind();

    default public OperationResult patchWithManifest(KubernetesCredentials credentials, String namespace, String name, KubernetesPatchOptions options, KubernetesManifest manifest, Task task, String opName) {
        credentials.patch(this.kind(), namespace, name, options, manifest, task, opName);
        return this.patch(namespace, name);
    }

    default public OperationResult patchWithJson(KubernetesCredentials credentials, String namespace, String name, KubernetesPatchOptions options, List<JsonPatch> patches, Task task, String opName) {
        credentials.patch(this.kind(), namespace, name, options, patches, task, opName);
        return this.patch(namespace, name);
    }

    default public OperationResult patch(String namespace, String name) {
        KubernetesManifest patchedManifest = new KubernetesManifest();
        patchedManifest.putIfAbsent("metadata", new HashMap());
        patchedManifest.setNamespace(namespace);
        patchedManifest.setName(name);
        patchedManifest.setKind(this.kind());
        return new OperationResult().addManifest(patchedManifest);
    }
}

