/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.job;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.artifact.ResourceVersioner;
import com.netflix.spinnaker.clouddriver.kubernetes.description.job.KubernetesRunJobOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.job.KubernetesRunJobDeploymentResult;
import com.netflix.spinnaker.clouddriver.kubernetes.op.manifest.KubernetesDeployManifestOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KubernetesRunJobOperation
implements AtomicOperation<KubernetesRunJobDeploymentResult> {
    private static final String OP_NAME = "RUN_KUBERNETES_JOB";
    private final KubernetesRunJobOperationDescription description;
    private final ResourceVersioner resourceVersioner;

    public KubernetesRunJobOperation(KubernetesRunJobOperationDescription description, ResourceVersioner resourceVersioner) {
        this.description = description;
        this.resourceVersioner = resourceVersioner;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public KubernetesRunJobDeploymentResult operate(List<KubernetesRunJobDeploymentResult> _unused) {
        KubernetesRunJobOperation.getTask().updateStatus(OP_NAME, "Running Kubernetes job...");
        KubernetesManifest jobSpec = this.description.getManifest();
        KubernetesKind kind = jobSpec.getKind();
        if (!kind.equals(KubernetesKind.JOB)) {
            throw new IllegalArgumentException("Only kind of Job is accepted for the Run Job operation.");
        }
        jobSpec.computeIfAbsent("metadata", k -> new HashMap());
        if (!this.description.getNamespace().isEmpty()) {
            jobSpec.setNamespace(this.description.getNamespace());
        }
        KubernetesManifestAnnotater.setDeploymentStrategy(jobSpec, KubernetesManifestStrategy.DeployStrategy.RECREATE);
        KubernetesDeployManifestDescription deployManifestDescription = new KubernetesDeployManifestDescription();
        ArrayList<KubernetesManifest> manifests = new ArrayList<KubernetesManifest>();
        manifests.add(jobSpec);
        Moniker moniker = new Moniker();
        moniker.setApp(this.description.getApplication());
        deployManifestDescription.setManifests(manifests);
        deployManifestDescription.setRequiredArtifacts(this.description.getRequiredArtifacts());
        deployManifestDescription.setOptionalArtifacts(this.description.getOptionalArtifacts());
        deployManifestDescription.setSource(KubernetesDeployManifestDescription.Source.text);
        deployManifestDescription.setCredentials(this.description.getCredentials());
        deployManifestDescription.setAccount(this.description.getAccount());
        deployManifestDescription.setMoniker(moniker);
        KubernetesDeployManifestOperation deployManifestOperation = new KubernetesDeployManifestOperation(deployManifestDescription, this.resourceVersioner);
        Object operationResult = deployManifestOperation.operate((List)new ArrayList());
        KubernetesRunJobDeploymentResult deploymentResult = new KubernetesRunJobDeploymentResult((OperationResult)operationResult);
        Map<String, List<String>> deployedNames = deploymentResult.getDeployedNamesByLocation();
        for (Map.Entry<String, Set<String>> e : ((OperationResult)operationResult).getManifestNamesByNamespace().entrySet()) {
            deployedNames.put(e.getKey(), new ArrayList(e.getValue()));
        }
        deploymentResult.setDeployedNamesByLocation(deployedNames);
        return deploymentResult;
    }
}

