/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesRollingRestartManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.CanRollingRestart;
import com.netflix.spinnaker.clouddriver.kubernetes.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesRollingRestartManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesRollingRestartManifestDescription description;
    private final KubernetesCredentials credentials;
    private static final String OP_NAME = "ROLLING_RESTART_KUBERNETES_MANIFEST";

    public KubernetesRollingRestartManifestOperation(KubernetesRollingRestartManifestDescription description) {
        this.description = description;
        this.credentials = description.getCredentials().getCredentials();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        KubernetesRollingRestartManifestOperation.getTask().updateStatus(OP_NAME, "Starting rolling restart operation in account " + this.credentials.getAccountName() + "...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesRollingRestartManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesHandler deployer = this.credentials.getResourcePropertyRegistry().get(coordinates.getKind()).getHandler();
        if (!(deployer instanceof CanRollingRestart)) {
            throw new IllegalArgumentException("Resource with " + String.valueOf(coordinates) + " does not support rolling restart");
        }
        CanRollingRestart canRollingRestart = (CanRollingRestart)((Object)deployer);
        KubernetesRollingRestartManifestOperation.getTask().updateStatus(OP_NAME, "Calling rolling restart operation for" + coordinates.getName() + " in namespace " + coordinates.getName() + "...");
        canRollingRestart.rollingRestart(this.credentials, coordinates.getNamespace(), coordinates.getName(), KubernetesRollingRestartManifestOperation.getTask(), OP_NAME);
        KubernetesRollingRestartManifestOperation.getTask().updateStatus(OP_NAME, "Rolling rollout operation completed successfully");
        return null;
    }
}

