/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.agent.KubernetesCachingAgentDispatcher;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesConfigurationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KubernetesCredentialsLifecycleHandler
implements CredentialsLifecycleHandler<KubernetesNamedAccountCredentials> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCredentialsLifecycleHandler.class);
    private final KubernetesProvider provider;
    private final KubernetesCachingAgentDispatcher cachingAgentDispatcher;
    private final KubernetesConfigurationProperties kubernetesConfigurationProperties;

    public void credentialsAdded(KubernetesNamedAccountCredentials credentials) {
        if (this.kubernetesConfigurationProperties.isLoadNamespacesInAccount()) {
            log.info("kubernetes.loadNamespacesInAccount flag is set to true - loading all namespaces for new account: {}", (Object)credentials.getName());
            ImmutableList<String> namespaces = credentials.getCredentials().getDeclaredNamespaces();
            if (namespaces.isEmpty()) {
                log.warn("New account {} did not return any namespace and could be unreachable or misconfigured", (Object)credentials.getName());
            }
        } else {
            log.info("kubernetes.loadNamespacesInAccount flag is disabled - new account: {} is unverified", (Object)credentials.getName());
        }
        Collection<KubernetesCachingAgent> newlyAddedAgents = this.cachingAgentDispatcher.buildAllCachingAgents(credentials);
        log.info("Adding {} agents for new account {}", (Object)newlyAddedAgents.size(), (Object)credentials.getName());
        this.provider.addAgents(newlyAddedAgents);
    }

    public void credentialsUpdated(KubernetesNamedAccountCredentials credentials) {
        ImmutableList<String> namespaces = credentials.getCredentials().getDeclaredNamespaces();
        if (namespaces.isEmpty()) {
            log.warn("Modified account {} did not return any namespace and could be unreachable or misconfigured", (Object)credentials.getName());
        }
        Collection<KubernetesCachingAgent> updatedAgents = this.cachingAgentDispatcher.buildAllCachingAgents(credentials);
        log.info("Scheduling {} agents for updated account {}", (Object)updatedAgents.size(), (Object)credentials.getName());
        this.provider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
        this.provider.addAgents(updatedAgents);
    }

    public void credentialsDeleted(KubernetesNamedAccountCredentials credentials) {
        this.provider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
    }

    @Generated
    public KubernetesCredentialsLifecycleHandler(KubernetesProvider provider, KubernetesCachingAgentDispatcher cachingAgentDispatcher, KubernetesConfigurationProperties kubernetesConfigurationProperties) {
        this.provider = provider;
        this.cachingAgentDispatcher = cachingAgentDispatcher;
        this.kubernetesConfigurationProperties = kubernetesConfigurationProperties;
    }
}

