/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesKindProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.security.GlobalKubernetesKindRegistry;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@NonnullByDefault
public final class KubernetesKindRegistry {
    private static final Logger log = LoggerFactory.getLogger(KubernetesKindRegistry.class);
    private final Map<KubernetesKind, KubernetesKindProperties> kindMap = new ConcurrentHashMap<KubernetesKind, KubernetesKindProperties>();
    private final GlobalKubernetesKindRegistry globalKindRegistry;
    private final Function<KubernetesKind, Optional<KubernetesKindProperties>> crdLookup;

    private KubernetesKindRegistry(GlobalKubernetesKindRegistry globalKindRegistry, Function<KubernetesKind, Optional<KubernetesKindProperties>> crdLookup, Iterable<KubernetesKindProperties> customProperties) {
        this.globalKindRegistry = globalKindRegistry;
        this.crdLookup = crdLookup;
        customProperties.forEach(this::registerKind);
    }

    private KubernetesKindProperties registerKind(KubernetesKindProperties kindProperties) {
        return this.kindMap.computeIfAbsent(kindProperties.getKubernetesKind(), k -> {
            log.info("Dynamically registering {}, (namespaced: {})", (Object)kindProperties.getKubernetesKind().toString(), (Object)kindProperties.isNamespaced());
            return kindProperties;
        });
    }

    KubernetesKindProperties getKindPropertiesOrDefault(KubernetesKind kind) {
        return this.getKindProperties(kind).orElseGet(() -> KubernetesKindProperties.withDefaultProperties(kind));
    }

    private Optional<KubernetesKindProperties> getKindProperties(KubernetesKind kind) {
        Optional<KubernetesKindProperties> globalResult = this.globalKindRegistry.getKindProperties(kind);
        if (globalResult.isPresent()) {
            return globalResult;
        }
        KubernetesKindProperties result = this.kindMap.get(kind);
        if (result != null) {
            return Optional.of(result);
        }
        return this.crdLookup.apply(kind).map(this::registerKind);
    }

    boolean isKindRegistered(KubernetesKind kind) {
        return this.getKindProperties(kind).isPresent();
    }

    ImmutableSet<KubernetesKind> getGlobalKinds() {
        return this.globalKindRegistry.getRegisteredKinds();
    }

    @Generated
    private KubernetesKindRegistry(GlobalKubernetesKindRegistry globalKindRegistry, Function<KubernetesKind, Optional<KubernetesKindProperties>> crdLookup) {
        this.globalKindRegistry = globalKindRegistry;
        this.crdLookup = crdLookup;
    }

    @Component
    public static class Factory {
        private final GlobalKubernetesKindRegistry globalKindRegistry;

        public Factory(GlobalKubernetesKindRegistry globalKindRegistry) {
            this.globalKindRegistry = globalKindRegistry;
        }

        KubernetesKindRegistry create(Function<KubernetesKind, Optional<KubernetesKindProperties>> crdLookup, Iterable<KubernetesKindProperties> customProperties) {
            return new KubernetesKindRegistry(this.globalKindRegistry, crdLookup, customProperties);
        }

        KubernetesKindRegistry create() {
            return new KubernetesKindRegistry(this.globalKindRegistry, k -> Optional.empty(), (Iterable<KubernetesKindProperties>)ImmutableList.of());
        }
    }
}

