/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;

public class KubernetesSelector {
    private final Kind kind;
    private final String key;
    private final List<String> values;

    @JsonCreator
    public KubernetesSelector(@JsonProperty(value="kind") @Nonnull Kind kind, @JsonProperty(value="key") String key, @JsonProperty(value="values") List<String> values) {
        if (Strings.isNullOrEmpty((String)key) && kind != Kind.ANY) {
            throw new IllegalArgumentException("Only an 'any' selector can have no key specified");
        }
        this.kind = kind;
        this.key = key;
        this.values = values;
    }

    public String toString() {
        switch (this.kind) {
            case ANY: {
                return "";
            }
            case EQUALS: {
                return String.format("%s = %s", this.key, this.values.get(0));
            }
            case NOT_EQUALS: {
                return String.format("%s != %s", this.key, this.values.get(0));
            }
            case CONTAINS: {
                return String.format("%s in (%s)", this.key, String.join((CharSequence)", ", this.values));
            }
            case NOT_CONTAINS: {
                return String.format("%s notin (%s)", this.key, String.join((CharSequence)", ", this.values));
            }
            case EXISTS: {
                return String.format("%s", this.key);
            }
            case NOT_EXISTS: {
                return String.format("!%s", this.key);
            }
        }
        throw new IllegalStateException("Unknown kind " + String.valueOf((Object)this.kind));
    }

    public static KubernetesSelector any() {
        return new KubernetesSelector(Kind.ANY, null, null);
    }

    public static KubernetesSelector equals(String key, String value) {
        return new KubernetesSelector(Kind.EQUALS, key, (List<String>)ImmutableList.of((Object)value));
    }

    public static KubernetesSelector notEquals(String key, String value) {
        return new KubernetesSelector(Kind.NOT_EQUALS, key, (List<String>)ImmutableList.of((Object)value));
    }

    public static KubernetesSelector contains(String key, List<String> values) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("At least one value must be supplied to a 'contains' selector");
        }
        return new KubernetesSelector(Kind.CONTAINS, key, values);
    }

    public static KubernetesSelector notContains(String key, List<String> values) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("At least one value must be supplied to a 'notcontains' selector");
        }
        return new KubernetesSelector(Kind.NOT_CONTAINS, key, values);
    }

    public static KubernetesSelector exists(String key) {
        return new KubernetesSelector(Kind.EXISTS, key, null);
    }

    public static KubernetesSelector notExists(String key) {
        return new KubernetesSelector(Kind.NOT_EXISTS, key, null);
    }

    @Generated
    public Kind getKind() {
        return this.kind;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public List<String> getValues() {
        return this.values;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesSelector)) {
            return false;
        }
        KubernetesSelector other = (KubernetesSelector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        List<String> this$values = this.getValues();
        List<String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesSelector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        List<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public static enum Kind {
        ANY,
        EQUALS,
        NOT_EQUALS,
        CONTAINS,
        NOT_CONTAINS,
        EXISTS,
        NOT_EXISTS;

    }
}

