/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.validator.manifest;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesPatchManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="patchManifest")
@Component
public class KubernetesPatchManifestValidator
extends DescriptionValidator<KubernetesPatchManifestDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List<KubernetesPatchManifestDescription> priorDescriptions, KubernetesPatchManifestDescription description, ValidationErrors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("patchKubernetesManifest", errors);
        if (!util.validateNotEmpty("patchBody", description.getPatchBody())) {
            return;
        }
        if (!util.validateNotEmpty("options.mergeStrategy", (Object)description.getOptions().getMergeStrategy())) {
            return;
        }
        if (!util.validateNotEmpty("options.record", description.getOptions().isRecord())) {
            return;
        }
        util.validateCredentials(this.provider, description.getAccount(), description.getPointCoordinates().getNamespace());
    }
}

