/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.validator.manifest;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.description.manifest.KubernetesUndoRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="undoRolloutManifest")
@Component
public class KubernetesUndoRolloutManifestValidator
extends DescriptionValidator<KubernetesUndoRolloutManifestDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List<KubernetesUndoRolloutManifestDescription> priorDescriptions, KubernetesUndoRolloutManifestDescription description, ValidationErrors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("undoRolloutKubernetesManifest", errors);
        if (!util.validateCredentials(this.provider, description.getAccount(), description.getPointCoordinates().getNamespace())) {
            return;
        }
        if (description.getNumRevisionsBack() == null && description.getRevision() == null) {
            util.reject("empty", "numRevisionsBack & revision");
        }
    }
}

