/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.AbstractLambdaFunctionDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.exception.InvalidAccountException;
import com.netflix.spinnaker.clouddriver.lambda.provider.view.LambdaFunctionProvider;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLambdaAtomicOperation<T extends AbstractLambdaFunctionDescription, K>
implements AtomicOperation<K> {
    @Autowired
    AmazonClientProvider amazonClientProvider;
    @Autowired
    AccountCredentialsProvider accountCredentialsProvider;
    @Autowired
    LambdaFunctionProvider lambdaFunctionProvider;
    private final String basePhase;
    T description;

    AbstractLambdaAtomicOperation(T description, String basePhase) {
        this.description = description;
        this.basePhase = basePhase;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    AWSLambda getLambdaClient() {
        String region = this.getRegion();
        NetflixAmazonCredentials credentialAccount = this.description.getCredentials();
        if (!credentialAccount.getLambdaEnabled()) {
            throw new InvalidAccountException("AWS Lambda is not enabled for provided account. \n");
        }
        return this.amazonClientProvider.getAmazonLambda(credentialAccount, region);
    }

    protected String getRegion() {
        return ((AbstractLambdaFunctionDescription)((Object)this.description)).getRegion();
    }

    protected AmazonCredentials getCredentials() {
        return (AmazonCredentials)this.accountCredentialsProvider.getCredentials(this.description.getAccount());
    }

    void updateTaskStatus(String status) {
        AbstractLambdaAtomicOperation.getTask().updateStatus(this.basePhase, status);
    }
}

