/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingResult;
import com.amazonaws.services.lambda.model.EventSourceMappingConfiguration;
import com.netflix.spinnaker.clouddriver.lambda.cache.model.LambdaFunction;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.UpsertLambdaFunctionEventMappingDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class DeleteLambdaEventSourceAtomicOperation
extends AbstractLambdaAtomicOperation<UpsertLambdaFunctionEventMappingDescription, Object>
implements AtomicOperation<Object> {
    public DeleteLambdaEventSourceAtomicOperation(UpsertLambdaFunctionEventMappingDescription description) {
        super(description, "DELETE_LAMBDA_FUNCTION_EVENT_MAPPING");
    }

    public Object operate(List priorOutputs) {
        LambdaFunction lambdaFunction = (LambdaFunction)this.lambdaFunctionProvider.getFunction(((UpsertLambdaFunctionEventMappingDescription)this.description).getAccount(), ((UpsertLambdaFunctionEventMappingDescription)this.description).getRegion(), ((UpsertLambdaFunctionEventMappingDescription)this.description).getFunctionName());
        List<EventSourceMappingConfiguration> eventSourceMappingConfigurations = lambdaFunction.getEventSourceMappings();
        for (EventSourceMappingConfiguration eventSourceMappingConfiguration : eventSourceMappingConfigurations) {
            if (!eventSourceMappingConfiguration.getEventSourceArn().equalsIgnoreCase(((UpsertLambdaFunctionEventMappingDescription)this.description).getEventSourceArn())) continue;
            ((UpsertLambdaFunctionEventMappingDescription)this.description).setUuid(eventSourceMappingConfiguration.getUUID());
            return this.deleteEventSourceMappingResult();
        }
        return null;
    }

    private DeleteEventSourceMappingResult deleteEventSourceMappingResult() {
        this.updateTaskStatus("Initializing Deleting of AWS Lambda Function Event Mapping Operation...");
        AWSLambda client = this.getLambdaClient();
        DeleteEventSourceMappingRequest request = new DeleteEventSourceMappingRequest().withUUID(((UpsertLambdaFunctionEventMappingDescription)this.description).getUuid());
        DeleteEventSourceMappingResult result = client.deleteEventSourceMapping(request);
        this.updateTaskStatus("Finished Deleting of AWS Lambda Function Event Mapping Operation...");
        return result;
    }
}

