/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.provider.view;

import com.amazonaws.services.lambda.model.FunctionConfiguration;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.clouddriver.lambda.cache.Keys;
import com.netflix.spinnaker.clouddriver.lambda.cache.client.LambdaCacheClient;
import com.netflix.spinnaker.clouddriver.model.Function;
import com.netflix.spinnaker.clouddriver.model.FunctionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LambdaFunctionProvider
implements FunctionProvider {
    private LambdaCacheClient awsLambdaCacheClient;
    private final Cache cacheView;

    @Autowired
    public LambdaFunctionProvider(Cache cacheView) {
        this.awsLambdaCacheClient = new LambdaCacheClient(cacheView);
        this.cacheView = cacheView;
    }

    public Collection<Function> getAllFunctions() {
        return new ArrayList<Function>(this.awsLambdaCacheClient.getAll());
    }

    public Function getFunction(String account, String region, String functionName) {
        String key = com.netflix.spinnaker.clouddriver.lambda.cache.Keys.getLambdaFunctionKey(account, region, functionName);
        return (Function)this.awsLambdaCacheClient.get(key);
    }

    public Set<Function> getApplicationFunctions(String applicationName) {
        CacheData application = this.cacheView.get(Namespace.APPLICATIONS.ns, Keys.getApplicationKey((String)applicationName));
        HashSet<Function> appFunctions = new HashSet<Function>();
        if (null != application && null != application.getRelationships()) {
            Collection functionRel = (Collection)application.getRelationships().get(Keys.Namespace.LAMBDA_FUNCTIONS.ns);
            if (null != functionRel && !functionRel.isEmpty()) {
                functionRel.forEach(functionKey -> {
                    Function function = (Function)this.awsLambdaCacheClient.get((String)functionKey);
                    if (null != function) {
                        appFunctions.add(function);
                    }
                });
            }
        } else {
            this.getAllFunctions().stream().filter(f -> f instanceof FunctionConfiguration).map(f -> (FunctionConfiguration)f).filter(f -> f.getFunctionName() != null).filter(f -> f.getFunctionName().startsWith(applicationName)).forEach(f -> appFunctions.add((Function)f));
        }
        return appFunctions;
    }
}

