/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.deploy.ops;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.LogType;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactDownloader;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.InvokeLambdaFunctionDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.description.InvokeLambdaFunctionOutputDescription;
import com.netflix.spinnaker.clouddriver.lambda.deploy.exception.LambdaOperationException;
import com.netflix.spinnaker.clouddriver.lambda.deploy.ops.AbstractLambdaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class InvokeLambdaAtomicOperation
extends AbstractLambdaAtomicOperation<InvokeLambdaFunctionDescription, InvokeLambdaFunctionOutputDescription>
implements AtomicOperation<InvokeLambdaFunctionOutputDescription> {
    @Generated
    private static final Logger log = LogManager.getLogger(InvokeLambdaAtomicOperation.class);
    @Autowired
    private ArtifactDownloader artifactDownloader;

    public InvokeLambdaAtomicOperation(InvokeLambdaFunctionDescription description) {
        super(description, "INVOKE_LAMBDA_FUNCTION");
    }

    public InvokeLambdaFunctionOutputDescription operate(List priorOutputs) {
        this.updateTaskStatus("Initializing Invoking AWS Lambda Function Operation...");
        if (((InvokeLambdaFunctionDescription)this.description).getPayloadArtifact() != null) {
            String payload = this.getPayloadFromArtifact(((InvokeLambdaFunctionDescription)this.description).getPayloadArtifact());
            return this.invokeFunction(((InvokeLambdaFunctionDescription)this.description).getFunctionName(), payload);
        }
        if (((InvokeLambdaFunctionDescription)this.description).getPayload() != null) {
            return this.invokeFunction(((InvokeLambdaFunctionDescription)this.description).getFunctionName(), ((InvokeLambdaFunctionDescription)this.description).getPayload());
        }
        return null;
    }

    private InvokeLambdaFunctionOutputDescription invokeFunction(String functionName, String payload) {
        AWSLambda client = this.getLambdaClient();
        InvokeRequest req = new InvokeRequest().withFunctionName(functionName).withLogType(LogType.Tail).withPayload(payload);
        String qualifierRegex = "|[a-zA-Z0-9$_-]+";
        if (((InvokeLambdaFunctionDescription)this.description).getQualifier().matches(qualifierRegex)) {
            req.setQualifier(((InvokeLambdaFunctionDescription)this.description).getQualifier());
        }
        if (((InvokeLambdaFunctionDescription)this.description).getTimeout() != -1) {
            req.setSdkRequestTimeout(((InvokeLambdaFunctionDescription)this.description).getTimeout() * 1000);
        }
        log.info("Invoking Lmabda function {} and waiting for it to complete", (Object)functionName);
        InvokeResult result = client.invoke(req);
        String ans = InvokeLambdaAtomicOperation.byteBuffer2String(result.getPayload(), Charset.forName("UTF-8"));
        InvokeLambdaFunctionOutputDescription is = new InvokeLambdaFunctionOutputDescription();
        is.setInvokeResult(result);
        is.setResponseString(ans);
        this.updateTaskStatus("Finished Invoking of AWS Lambda Function Operation...");
        return is;
    }

    public static String byteBuffer2String(ByteBuffer buf, Charset charset) {
        byte[] bytes;
        if (buf == null) {
            return null;
        }
        if (buf.hasArray()) {
            bytes = buf.array();
        } else {
            buf.rewind();
            bytes = new byte[buf.remaining()];
        }
        return new String(bytes, charset);
    }

    private String getPayloadFromArtifact(Artifact artifact) {
        String payloadString;
        Path directory = this.createEmptyDirectory();
        File payloadFile = this.downloadFileToDirectory(artifact, directory);
        try {
            payloadString = FileUtils.readFileToString((File)payloadFile, (String)"UTF8");
        }
        catch (IOException e) {
            throw new LambdaOperationException("Unable to read Artifact file to string.");
        }
        finally {
            try {
                FileUtils.cleanDirectory((File)directory.toFile());
                FileUtils.forceDelete((File)directory.toFile());
            }
            catch (Exception e) {
                throw new LambdaOperationException("Unable to clean up and delete directory.");
            }
        }
        return payloadString;
    }

    private Path createEmptyDirectory() {
        Path path;
        try {
            path = Files.createTempDirectory("awslambdainvoke-", new FileAttribute[0]);
            FileUtils.cleanDirectory((File)path.toFile());
        }
        catch (IOException ex) {
            throw new LambdaOperationException("Unable to create empty directory for AWS Lambda Invocation.");
        }
        return path;
    }

    private File downloadFileToDirectory(Artifact artifact, Path directory) {
        File targetFile;
        try {
            InputStream inStream = this.artifactDownloader.download(artifact);
            targetFile = new File(directory + "/ARTIFACT.yaml");
            FileUtils.copyInputStreamToFile((InputStream)inStream, (File)targetFile);
            IOUtils.closeQuietly((Closeable)inStream);
        }
        catch (IOException e) {
            throw new LambdaOperationException("Failed to load payload Artifact.");
        }
        return targetFile;
    }
}

